// ObjectMap.h : CObjectMap ̐錾

#ifndef __OBJECTMAP_H_
#define __OBJECTMAP_H_

#include "resource.h"       // C V{
#include <map>
#include <string>
using namespace std;

typedef map<_bstr_t,VARIANT> VariantMap;

/////////////////////////////////////////////////////////////////////////////
// CObjectMap
class ATL_NO_VTABLE CObjectMap : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CObjectMap, &CLSID_ObjectMap>,
	public ISupportErrorInfo,
	public IDispatchImpl<IObjectMap, &IID_IObjectMap, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CObjectMap()
	{
	}
	void FinalRelease()
	{
		Clear();
		ATLTRACE("CObjectMap::FinalRelease\n");
	}

DECLARE_REGISTRY_RESOURCEID(IDR_OBJECTMAP)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CObjectMap)
	COM_INTERFACE_ENTRY(IObjectMap)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IObjectMap
public:
	STDMETHOD(SaveProfile)(/*[in]*/IUnknown* punkVal);
	STDMETHOD(LoadProfile)(/*[in]*/IUnknown* punkVal);
	STDMETHOD(Erase)(/*[in]*/VARIANT key);
	STDMETHOD(get_IsExist)(/*[in]*/VARIANT key, /*[out, retval]*/ BOOL *pVal);
	STDMETHOD(ExpandVariables)(/*[in]*/VARIANT text,/*[in,optional]*/VARIANT env,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(get_NearValue)(/*[in]*/VARIANT key,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(FindNear)(/*[in]*/VARIANT key,/*[out,retval]*/VARIANT* pVal);
	STDMETHOD(get__NewEnum)(/*[out, retval]*/ IUnknown* *pVal);
	STDMETHOD(CreateMap)(/*[out,retval]*/IUnknown** punkVal);
	STDMETHOD(Duplicate)(/*[out,retval]*/IUnknown** punkVal);
	STDMETHOD(Clear)();
	STDMETHOD(get_Count)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Value)(/*[in]*/VARIANT key, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_Value)(/*[in]*/VARIANT key, /*[in]*/ VARIANT newVal);
protected:
	VariantMap m_mapVariant;
};

#endif //__OBJECTMAP_H_
