// Control.h : CControl ̐錾

#ifndef __CONTROL_H_
#define __CONTROL_H_

#include "resource.h"       // C V{
#include "treeitem.h"

/////////////////////////////////////////////////////////////////////////////
// CControl
class ATL_NO_VTABLE CControl : 
	public CComObjectRootEx<CComSingleThreadModel>,
//	public CComCoClass<CControl, &CLSID_Control>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CControl>,
	public IDispatchImpl<IControl, &IID_IControl, &LIBID_SERAPHYSCRIPTTOOLSLib>
{
public:
	CControl()
	{
		m_x = 0;
		m_y = 0;
		m_h = 0;
		m_w = 0;
		m_bChecked  = false;
		m_exstyle   = 0;
		m_style     = 0;
		m_nID       = 0;
		m_hWnd      = NULL;
		m_hParent   = NULL;
		ZeroMemory(m_classname,MAX_PATH);
		ZeroMemory(m_caption  ,MAX_PATH);
		// XgRg[p
		m_nColumnCount = 0;
		m_dLastSortColumn = -1; //ŌɃ\[gJ
	}
	void SetParam(DWORD afterstyle,DWORD exstyle,LPCSTR classname,LPCSTR caption,DWORD style,int x,int y,int w,int h,int nID)
	{
		CHAR tmp[64];
		wsprintf(tmp,"OnCommand%d",nID);
		m_x = x;
		m_y = y;
		m_h = h;
		m_w = w;
		m_exstyle   = exstyle;
		m_style     = style;
		lstrcpy(m_classname,classname);
		lstrcpy(m_caption,caption);
		m_nID       = nID;
		m_bstrClassEvent = tmp;
		m_hWnd = NULL;
		m_hParent = NULL;
		m_afterstyle = afterstyle;
	}
	HWND GetHWnd()
	{
		return m_hWnd;
	}
	void Redraw()
	{
		RedrawWindow(m_hWnd,NULL,NULL,RDW_ERASE|RDW_FRAME|RDW_INTERNALPAINT|RDW_INVALIDATE);
	}
	void SetFont(HFONT hFont)
	{
		if(m_hWnd){
			::SendMessage(m_hWnd,WM_SETFONT,(WPARAM)hFont,true);
		}
	}
	void SetColor(DWORD color)
	{
		if(m_hWnd){
			if(!lstrcmp(m_classname,WC_TREEVIEW)){
				TreeView_SetBkColor(m_hWnd,COLORREF(color));
			}
			else if(!lstrcmp(m_classname,WC_LISTVIEW)){
				ListView_SetBkColor(m_hWnd,COLORREF(color));
			}
		}
	}
	void FinalRelease()
	{
		ATLTRACE("CControl::FinalRelease\r\n");
		Destroy();
	}

//DECLARE_REGISTRY_RESOURCEID(IDR_CONTROL)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CControl)
	COM_INTERFACE_ENTRY(IControl)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
END_COM_MAP()
BEGIN_CONNECTION_POINT_MAP(CControl)
END_CONNECTION_POINT_MAP()


// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

// IControl
public:
	STDMETHOD(CreateChild)(/*[in]*/VARIANT text,/*[in]*/VARIANT varItem,/*[out,retval]*/VARIANT* pvarUnk);
	void GetClassEvent(BSTR* pEventName);
	STDMETHOD(SetClassEvent)(/*[in]*/BSTR name,/*[out,retval]*/VARIANT* pUnk);
	STDMETHOD(get_ItemText)(/*[in]*/VARIANT idx, /*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_ItemText)(/*[in]*/VARIANT idx, /*[in]*/ BSTR newVal);
	STDMETHOD(DeleteSelectedItem)();
	STDMETHOD(get_ItemCheckState)(/*[in]*/VARIANT idx, /*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_ItemCheckState)(/*[in]*/VARIANT idx, /*[in]*/ BOOL newVal);
	STDMETHOD(DeleteAllItems)();
	STDMETHOD(get_ItemObject)(/*[in]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_TreeRoot)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(get_SelectedCount)(/*[out, retval]*/ short *pVal);
	STDMETHOD(get_ItemSelectState)(/*[in]*/VARIANT idx, /*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_ItemSelectState)(/*[in]*/VARIANT idx, /*[in]*/ VARIANT newVal);
	STDMETHOD(get__NewEnum)(/*[out, retval]*/ IUnknown* *pVal);
	STDMETHOD(get_CurrentSelectedItem)(/*[out, retval]*/ VARIANT *pVal);
	STDMETHOD(put_CurrentSelectedItem)(/*[in]*/ VARIANT newVal);
	STDMETHOD(GetCount)(/*[out,retval]*/VARIANT* pRet);
	STDMETHOD(DeleteString)(/*[in]*/VARIANT idx,/*[out,retval]*/VARIANT* pRet);
	STDMETHOD(GetColumnText)(/*[in]*/VARIANT idx,/*[in]*/VARIANT col,/*[out,retval]*/VARIANT* pText);
	STDMETHOD(SetColumnText)(/*[in]*/VARIANT item,/*[in]*/VARIANT col,/*[in]*/VARIANT text);
	STDMETHOD(AddString)(/*[in]*/VARIANT text,/*[out,retval]*/VARIANT* pRet);
	STDMETHOD(get_HWND)(/*[out, retval]*/ long *pVal);
	STDMETHOD(Refresh)();
	STDMETHOD(get_ClassName)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_Exstyle)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Exstyle)(/*[in]*/ long newVal);
	STDMETHOD(get_Style)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_Style)(/*[in]*/ long newVal);
	STDMETHOD(SetID)(/*[in]*/VARIANT varID,/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(SetCheck)(/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(SetPlacement)(/*[in]*/VARIANT x,/*[in]*/VARIANT y,/*[in,optional]*/VARIANT w,/*[in,optional]*/VARIANT h,/*[out,retval]*/VARIANT* pvarUnk);
	STDMETHOD(get_PosY)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_PosY)(/*[in]*/ short newVal);
	STDMETHOD(get_PosX)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_PosX)(/*[in]*/ short newVal);
	STDMETHOD(get_Height)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_Height)(/*[in]*/ short newVal);
	STDMETHOD(get_Width)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_Width)(/*[in]*/ short newVal);
	STDMETHOD(get_CheckState)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_CheckState)(/*[in]*/ short newVal);
	STDMETHOD(get_Enable)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Enable)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_Visibility)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(put_Visibility)(/*[in]*/ BOOL newVal);
	STDMETHOD(get_ID)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_ID)(/*[in]*/ short newVal);
	STDMETHOD(get_Text)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Text)(/*[in]*/ BSTR newVal);
	void OnRClick();
	void ListSort(int column);
	BOOL Create(HWND hParam);
	int GetID();
	void GetThisInterface(VARIANT* pvarUnk);
	void Destroy();

protected:
//	LRESULT (CALLBACK *subclassproc)(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
//	static LRESULT CALLBACK WinProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
static int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort); 
 
protected:
	int m_x;
	int m_y;
	int m_h;
	int m_w;
	int m_nID;
	BOOL m_bChecked;
	DWORD m_exstyle;
	DWORD m_style;
	DWORD m_afterstyle;
	TCHAR m_caption[MAX_PATH];
	TCHAR m_classname[MAX_PATH];
	_bstr_t m_bstrClassEvent;
	HWND m_hParent;
	HWND m_hWnd;
	BOOL m_bSortReverse;
	VARTYPE m_typCompare;
	int m_dLastSortColumn;
	int m_nColumnCount;
	LPSTR ConvertVariantToString(VARIANT text);
};

#endif //__CONTROL_H_
