#include "opcode.hpp"

using namespace opcode;


static Opcode instruction_set[] = {
	{BRK,AM_NONE}, {ORA,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {ORA,ZERO}, {ASL,ZERO}, {UND,AM_DATA},
	{PHP,AM_NONE}, {ORA,IMM}, {ASL,REG_A}, {UND,AM_DATA},
	{UND,AM_DATA}, {ORA,ABS}, {ASL,ABS}, {UND,AM_DATA},
	
	{BPL,REL}, {ORA,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {ORA,ZERO_X}, {ASL,ZERO_X}, {UND,AM_DATA},
	{CLC,AM_NONE}, {ORA,ABS_Y}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {ORA,ABS_X}, {ASL,ABS_X}, {UND,AM_DATA},

	{JSR,ABS}, {AND,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{BIT,ZERO}, {AND,ZERO}, {ROL,ZERO}, {UND,AM_DATA},
	{PLP,AM_NONE}, {AND,IMM}, {ROL,REG_A}, {UND,AM_DATA},
	{BIT,ABS}, {AND,ABS}, {ROL,ABS}, {UND,AM_DATA},

	{BMI,REL}, {AND,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {AND,ZERO_X}, {ROL,ZERO_X}, {UND,AM_DATA},
	{SEC,AM_NONE}, {AND,ABS_Y}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {AND,ABS_X}, {ROL,ABS_X}, {UND,AM_DATA},

	{RTI,AM_NONE}, {EOR,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {EOR,ZERO}, {LSR,ZERO}, {UND,AM_DATA},
	{PHA,AM_NONE}, {EOR,IMM}, {LSR,REG_A}, {UND,AM_DATA},
	{JMP,ABS}, {EOR,ABS}, {LSR,ABS}, {UND,AM_DATA},

	{BVC,REL}, {EOR,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {EOR,ZERO_X}, {LSR,ZERO_X}, {UND,AM_DATA},
	{CLI,AM_NONE}, {EOR,ABS_Y}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {EOR,ABS_X}, {LSR,ABS_X}, {UND,AM_DATA},

	{RTS,AM_NONE}, {ADC,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {ADC,ZERO}, {ROR,ZERO}, {UND,AM_DATA},
	{PLA,AM_NONE}, {ADC,IMM}, {ROR,REG_A}, {UND,AM_DATA},
	{JMP,IND}, {ADC,ABS}, {ROR,ABS}, {UND,AM_DATA},

	{BVS,REL}, {ADC,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {ADC,ZERO_X}, {ROR,ZERO_X}, {UND,AM_DATA},
	{SEI,AM_NONE}, {ADC,ABS_Y}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {ADC,ABS_X}, {ROR,ABS_X}, {UND,AM_DATA},

	{UND,AM_DATA}, {STA,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{STY,ZERO}, {STA,ZERO}, {STX,ZERO}, {UND,AM_DATA},
	{DEY,AM_NONE}, {UND,AM_DATA}, {TXA,AM_NONE}, {UND,AM_DATA},
	{STY,ABS}, {STA,ABS}, {STX,ABS}, {UND,AM_DATA},

	{BCC,REL}, {STA,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{STY,ZERO_X}, {STA,ZERO_X}, {STX,ZERO_Y}, {UND,AM_DATA},
	{TYA,AM_NONE}, {STA,ABS_Y}, {TXS,AM_NONE}, {UND,AM_DATA},
	{UND,AM_DATA}, {STA,ABS_X}, {UND,AM_DATA}, {UND,AM_DATA},

	{LDY,IMM}, {LDA,PRE_IND}, {LDX,IMM}, {UND,AM_DATA},
	{LDY,ZERO}, {LDA,ZERO}, {LDX,ZERO}, {UND,AM_DATA},
	{TAY,AM_NONE}, {LDA,IMM}, {TAX,AM_NONE}, {UND,AM_DATA},
	{LDY,ABS}, {LDA,ABS}, {LDX,ABS}, {UND,AM_DATA},

	{BCS,REL}, {LDA,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{LDY,ZERO_X}, {LDA,ZERO_X}, {LDX,ZERO_Y}, {UND,AM_DATA},
	{CLV,AM_NONE},{LDA,ABS_Y}, {TSX,AM_NONE}, {UND,AM_DATA},
	{LDY,ABS_X}, {LDA,ABS_X}, {LDX,ABS_Y}, {UND,AM_DATA},

	{CPY,IMM}, {CMP,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{CPY,ZERO}, {CMP,ZERO}, {DEC,ZERO}, {UND,AM_DATA},
	{INY,AM_NONE}, {CMP,IMM}, {DEX,AM_NONE}, {UND,AM_DATA},
	{CPY,ABS}, {CMP,ABS}, {DEC,ABS}, {UND,AM_DATA},

	{BNE,REL}, {CMP,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {CMP,ZERO_X}, {DEC,ZERO_X}, {UND,AM_DATA},
	{CLD,AM_NONE}, {CMP,ABS_Y}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {CMP,ABS_X}, {DEC,ABS_X}, {UND,AM_DATA},

	{CPX,IMM}, {SBC,PRE_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{CPX,ZERO}, {SBC,ZERO}, {INC,ZERO}, {UND,AM_DATA},
	{INX,AM_NONE}, {SBC,IMM}, {NOP,AM_NONE}, {UND,AM_DATA},
	{CPX,ABS}, {SBC,ABS}, {INC,ABS}, {UND,AM_DATA},

	{BEQ,REL}, {SBC,POST_IND}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {SBC,ZERO_X}, {INC,ZERO_X}, {UND,AM_DATA},
	{SED,AM_NONE}, {SBC,ABS_Y}, {UND,AM_DATA}, {UND,AM_DATA},
	{UND,AM_DATA}, {SBC,ABS_X}, {INC,ABS_X}, {UND,AM_DATA}
};

static const char* mnemonics[] = {
    ".db",
    "adc","and","asl","bcc","bcs","beq","bit","bmi",
    "bne","bpl","brk","bvc","bvs","clc","cld","cli",
    "clv","cmp","cpx","cpy","dec","dex","dey","eor",
    "inc","inx","iny","jmp","jsr","lda","ldx","ldy",
    "lsr","nop","ora","pha","php","pla","plp","rol",
    "ror","rti","rts","sbc","sec","sed","sei","sta",
    "stx","sty","tax","tay","tsx","txa","txs","tya",
	
    ".dw",
    ".dw",
    ".dw",
    "This is last."
};

const ::Opcode&
OpcodeHelper::decode(Byte byte) { return instruction_set[byte]; }

Byte OpcodeHelper::encode(OpcodeType type, AddressingMode mode)
{
    for (unsigned i=0; i<0x100; ++i) {
        Opcode& op=instruction_set[i];
        if (op.type()==type && op.mode() == mode) {
            return i;
        }
    }
    return 0;
}


const char*
OpcodeHelper::mnemonic(OpcodeType type) { return mnemonics[type]; }

unsigned OpcodeHelper::bytelength(AddressingMode mode)
{
    switch (mode){
    case ABS: case ABS_X: case ABS_Y: case IND:
        return 3;
    case ZERO: case ZERO_X: case ZERO_Y:
    case IMM: case REL:	case PRE_IND: case POST_IND:
        return 2;
    default:
        return 1;
    }
}




