
#include "instruction.hpp"
#include "disassembler.hpp"
#include "nes_memory_map.hpp"
#include "reference.hpp"

void Instruction::display(std::ostream& os)const
{
	Disassembler d(os);
	d.writeMnemonic(*this);
}

bool InstructionHelper::isRomAccess(const Instruction& instr)
{
    return instr.mode()==opcode::ABS
        && instr.operand()>=nes::CODE_OFFSET;
}
bool InstructionHelper::isTransfer(const Instruction& instr)
{
    ReferenceType type = ReferenceHelper::map(instr.type());
    switch (type) {
    case reference::CALL:
    case reference::BREAK:
    case reference::JUMP:
    case reference::RETURN:
    case reference::BRANCH:
        return true;
    default:
        return false;
    }
}
