#pragma once

#include "basic_type.hpp"
#include "reference.hpp"

class INesHeader;
class INesFile;
class NesMemoryMapper;

void displayRawAssembly(const std::vector<PByteSequence>& banks,
						const std::vector<Word>& origins);

void displayINesFile(std::ostream& os, 
                     const INesFile& nes,
					 const std::vector<Word>& interrupts);

void displayOrigins(std::ostream& os, const std::vector<Word>& origins);

void displayBankAddress(std::ostream& os,
                        Byte bank_num, Word addr);
void displayCodeDataStats(std::ostream& os, const ByteSequence& bytes);

void displayCodeDataInfo(std::ostream& os,
                         const ByteSequence& bytes,
                         const std::vector<Word>& origins);

void displayCodeDataFlag(std::ostream& os,Byte f);
void displayCodeDataRegeon(std::ostream& os,
                           const ByteSequence& bytes,
                           const std::vector<Word>& origins,
                           Byte bank_num,
                           Word begin,
                           Word end);
void displayRawAssemblyRegeon(
        std::ostream& os,
        const std::vector<PByteSequence>& banks,
        const std::vector<Word>& origins,
        Byte bank_num,
        Word begin,
        Word end);

