#pragma once
#include "ines_file.hpp"
#include <string>
#include "utils/hex_form.hpp"


class CodeServer
{
public:
    /** convert mapper num to name*/
    virtual std::string mapper(unsigned mapper_id)
	{
		switch (mapper_id) {
		case 0: return "NROM";
		case 1: return "MMC1";
		case 2: return "UNROM";
		case 3: return "CNROM";
		case 4: return "MMC3";
		case 5: return "MMC5";
		default: return "unknown";
		}
	}
	virtual std::string bytecode(const std::vector<Byte>& bytes)
	{
		std::string result;
		for (unsigned i=0; i<bytes.size(); ++i){
			HexForm h(bytes[i]);
			result += h.width(2).to_s() + " ";
		}
		return result;
	}
	virtual std::string operand(Word operand, AddressingMode mode)
	{
		HexForm h(operand);
		std::string single=h.width(1).to_s();
		std::string byte=h.width(2).to_s();
		std::string word=h.width(4).to_s();
		std::string zero="$"+byte;
		std::string abs="$"+word;
		const char x[] = ", x";
		const char y[] = ", y";
	
		switch (mode){
		case opcode::IMM:
            if (operand < 10) return "#" + single;
            else return "#$"+byte;
		case opcode::ZERO: return zero;
		case opcode::ZERO_X: return zero + x;
		case opcode::ZERO_Y: return zero + y;
		case opcode::REL: return "$" + word;
		case opcode::ABS: return abs;
		case opcode::ABS_X: return abs + x;
		case opcode::ABS_Y: return abs + y;
		case opcode::IND: return "[" + abs + "]";
		case opcode::PRE_IND: return "[" + zero + x + "]";
		case opcode::POST_IND: return "[" + zero + "]" +y;
		case opcode::REG_A: return "a";
		case opcode::AM_DATA: return "$"+byte;
		default: return "";
		}
	}
    
};
