#pragma once

#include <vector>
#include <boost/shared_ptr.hpp>

typedef unsigned char Byte;
typedef unsigned Word;
typedef long MemoryAddress;
typedef long MemoryID;

typedef std::vector<Byte> ByteSequence;
typedef boost::shared_ptr<std::vector<Byte> > PByteSequence;


namespace bit8 {

inline Word lowHigh(Byte low, Byte high){ return low + (high << 8); }
// the carry of low byte is ignored.
inline Word addressIndex(Word addr, Byte idx)
{
	Byte low=(addr+idx)&0xFF, high=addr >> 8;
	return lowHigh(low, high);
}
inline MemoryID addressIndexLong(MemoryID id, Byte idx)
{
	Byte low=(id+idx)&0xFF;
	MemoryID high=id >> 8;
	return low + (high << 8);
}
inline bool byteBit(Byte byte, unsigned bit)
{ return byte & (1<<bit); }

inline void setByteBit(Byte& byte, unsigned bit, bool val) {
	Byte setter=1<<bit;
	Byte mask=~setter;
	byte = (byte & mask) | (val ? setter : 0);
}
inline bool signBit(Byte byte) { return byteBit(byte, 7); }



}

namespace memory_id {

enum MemoryIDConstants {
    NONE=-1,
    ENTRY=-2,    // top level referer id.
    EXIT=-3, // call graph special node id.
	MEMORY_ID_OFFSET=0x8000,
};

}// end of namespace

class BitHelper
{
public:
    static bool isOverflowAddtion(Byte a, Byte b, Byte carry)
    {
        Byte result = a + b + carry;
        bool sa = bit8::signBit(a);
        bool sb = bit8::signBit(b);
        bool sr = bit8::signBit(result);
        return ((~sa & ~sb) & sr) | ((sa & sb) & (~sr));
    }
    static bool isOverflowSubtraction(Byte a, Byte b, Byte carry)
    {
        Byte result = a - b - 1 + carry;
        bool sa = bit8::signBit(a);
        bool sb = bit8::signBit(b);
        bool sr = bit8::signBit(result);
        return ((~sa & sb) & sr) | ((sa & ~sb) & (~sr));
    }
};
