//	Roast+ License v0.1

//	SIMD

#ifndef __SFJP_OPENMGL_roast_simd_simd_operator_HPP__
#define __SFJP_OPENMGL_roast_simd_simd_operator_HPP__


/*	CgVbN	***********************************/
#include <nmmintrin.h>   // MMX-SSE4.2߃ZbggpꍇCN[h //
#include <smmintrin.h>   // MMX-SSE4.1߃ZbggpꍇCN[h //
#include <intrin.h>      // MMX-SSE3߃ZbggpꍇCN[h   //
#include <emmintrin.h>   // MMX-SSE2߃ZbggpꍇCN[h   //
#include <xmmintrin.h>   // MMX-SSE߃ZbggpꍇCN[h    //
#include <mmintrin.h>    // MMX߃ZbggpꍇCN[h        //

/*	CgVbN̊֌W VC++.NET (2003) ȍ~łǂ߂炵EEEB
	܂VC++6.0łProcessorPackȂMMX/SSEAZuĝǂˁEEE	*/


#include "roast/simd/simd_types.hpp"

#ifndef _ROAST_FORCE_INLINE
	#define _ROAST_FORCE_INLINE __forceinline 
#endif

namespace roast
{
	namespace simd 
	{
		/*	ʊ֐  *******/
		_ROAST_FORCE_INLINE __m128 m128_int4_to_float4( const __m128i& m ){
			return _mm_cvtepi32_ps(m);
		}
		_ROAST_FORCE_INLINE __m128i m128_float4_to_int4( const __m128& m ){
			return _mm_cvttps_epi32(m);
		}

		////////////////////////////////////////////////

		//	xmm_registeŕiꉻĂȂj錾
		template <typename _REGISTER_T, int _PERMIT_SIMD>
		class xmm_register : public ::roast::simd::simd_types
		{
		};


		//	xmm_registervoidꉻ錾
		template <int _PERMIT_SIMD>
		class xmm_register<void,_PERMIT_SIMD> : public ::roast::simd::simd_types
		{
		};

	}
}

#define _ROAST_IS_ON_SSE		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END
#define _ROAST_IS_ON_SSE1		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE1 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END
#define _ROAST_IS_ON_SSE2		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE2 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END
#define _ROAST_IS_ON_SSE3		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE3 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END
#define _ROAST_IS_ON_SSE4		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE4 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END
#define _ROAST_IS_ON_SSE41		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE41 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END
#define _ROAST_IS_ON_SSE42		_PERMIT_SIMD >= ROAST_SIMD_TYPE_SSE42 && _PERMIT_SIMD <= ROAST_SIMD_TYPE_INTEL_END

#include "roast/simd/simd_make_shuffles.hpp"

#define ROAST_MAKE_SHUFFLE_BITS(n1,n2,n3,n4)		( (n1-1) + ((n2-1) << 2) + ((n3-1) << 4) + ((n4-1) << 6) )


#include "roast/simd/float_xmm_register.hpp"
#include "roast/simd/int_xmm_register.hpp"

namespace roast
{
	namespace simd 
	{

		/*************************************************************************/

		//	SSE1
		template <typename _REGISTER_T>
		class SSE1_xmm_register : public ::roast::simd::xmm_register< _REGISTER_T, ::roast::simd::simd_types::SSE1 >
		{
		public:
			SSE1_xmm_register(){}
			SSE1_xmm_register( const xmm_register& reg )
				: xmm_register(reg){}

			SSE1_xmm_register( __m128 m )
				: xmm_register(m){}

			virtual ~SSE1_xmm_register(){}
		};

		//	SSE2
		template <typename _REGISTER_T>
		class SSE2_xmm_register : public ::roast::simd::xmm_register< _REGISTER_T, ::roast::simd::simd_types::SSE2 >
		{
		public:
			SSE2_xmm_register(){}
			SSE2_xmm_register( const xmm_register& reg )
				: xmm_register(reg){}

			SSE2_xmm_register( __m128 m )
				: xmm_register(m){}

			virtual ~SSE2_xmm_register(){}
		};

		//	SSE3
		template <typename _REGISTER_T>
		class SSE3_xmm_register : public ::roast::simd::xmm_register< _REGISTER_T, ::roast::simd::simd_types::SSE3 >
		{
		public:
			SSE3_xmm_register(){}
			SSE3_xmm_register( const xmm_register& reg )
				: xmm_register(reg){}

			SSE3_xmm_register( __m128 m )
				: xmm_register(m){}

			virtual ~SSE3_xmm_register(){}
		};

		//	SSE4 (SSE4.1)
		template <typename _REGISTER_T>
		class SSE4_xmm_register : public ::roast::simd::xmm_register< _REGISTER_T, ::roast::simd::simd_types::SSE4 >
		{
		public:
			SSE4_xmm_register(){}
			SSE4_xmm_register( const xmm_register& reg )
				: xmm_register(reg){}

			SSE4_xmm_register( __m128 m )
				: xmm_register(m){}

			virtual ~SSE4_xmm_register(){}
		};

		//	SSE4.2
		template <typename _REGISTER_T>
		class SSE42_xmm_register : public ::roast::simd::xmm_register< _REGISTER_T, ::roast::simd::simd_types::SSE42 >
		{
		public:
			SSE42_xmm_register(){}
			SSE42_xmm_register( const xmm_register& reg )
				: xmm_register(reg){}

			SSE42_xmm_register( __m128 m )
				: xmm_register(m){}

			virtual ~SSE42_xmm_register(){}
		};
	}
}

#endif//__SFJP_OPENMGL_roast_simd_simd_operator_HPP__
