/* vim:set ts=4 sts=4 sw=4 noet fenc=utf-8:

   Copyright 2009 senju@users.sourceforge.jp

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */

package jp.sourceforge.rabbitBTS.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import jp.sourceforge.rabbitBTS.dao.AccountDao;
import jp.sourceforge.rabbitBTS.dao.BbsDao;
import jp.sourceforge.rabbitBTS.models.Account;
import jp.sourceforge.rabbitBTS.models.BbsPost;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;

/**
 * BBS用サービス
 */
public class BbsService {
	@Autowired
	private BbsDao bbsDao;
	@Autowired
	private AccountDao accountDao;

	/**
	 * 登録されている投稿を返す。
	 * 
	 * TODO: 日付順、件数制限、ページング
	 * 
	 * @return 投稿のリスト。
	 */
	public List<BbsPost> fetchPosts() {
		final Collection<BbsPost> posts = this.bbsDao.getAllPosts();
		for (final BbsPost bbsPost : posts) {
			try {
				// 投稿者の検索
				if (bbsPost.getAuthorId() != null) {
					final Account acc = this.accountDao.get(bbsPost
							.getAuthorId());
					bbsPost.setAuthor(acc);
				} else {
					bbsPost.setAuthor(null);
					bbsPost.setAuthorId(null);
				}
			} catch (final ObjectRetrievalFailureException e) {
				bbsPost.setAuthor(null);
				bbsPost.setAuthorId(null);
			}
		}
		return new ArrayList<BbsPost>(posts);
	}

	/**
	 * 新規投稿を登録する。
	 * 
	 * @param bbsPost
	 *            登録する投稿
	 * @param account
	 *            投稿の作成者
	 */
	public void addNewPost(BbsPost bbsPost, Account account) {
		// 投稿者の存在チェック(見つからない場合ランタイム例外)
		this.accountDao.get(account.getAccountId());

		// 保存
		bbsPost.setAuthorId(account.getAccountId());
		bbsPost.setDate(new Date());

		this.bbsDao.savePost(bbsPost);
	}

}
