/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.rolling.helper.IntegerTokenConverter;
import ch.qos.logback.core.rolling.helper.RenameUtil;
import java.io.File;

public class FixedWindowRollingPolicy
extends RollingPolicyBase {
    static final String FNP_NOT_SET = "The \"FileNamePattern\" property must be set before using FixedWindowRollingPolicy. ";
    static final String PRUDENT_MODE_UNSUPPORTED = "See also http://logback.qos.ch/codes.html#tbr_fnp_prudent_unsupported";
    static final String SEE_PARENT_FN_NOT_SET = "Please refer to http://logback.qos.ch/codes.html#fwrp_parentFileName_not_set";
    int maxIndex = 7;
    int minIndex = 1;
    RenameUtil util = new RenameUtil();
    Compressor compressor;
    private static int MAX_WINDOW_SIZE = 12;

    public void start() {
        IntegerTokenConverter itc;
        this.util.setContext(this.context);
        if (this.fileNamePatternStr == null) {
            this.addError(FNP_NOT_SET);
            this.addError("See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
            throw new IllegalStateException("The \"FileNamePattern\" property must be set before using FixedWindowRollingPolicy. See also http://logback.qos.ch/codes.html#tbr_fnp_not_set");
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr, this.context);
        this.determineCompressionMode();
        if (this.isParentPrudent()) {
            this.addError("Prudent mode is not supported with FixedWindowRollingPolicy.");
            this.addError(PRUDENT_MODE_UNSUPPORTED);
            throw new IllegalStateException("Prudent mode is not supported.");
        }
        if (this.getParentsRawFileProperty() == null) {
            this.addError("The File name property must be set before using this rolling policy.");
            this.addError(SEE_PARENT_FN_NOT_SET);
            throw new IllegalStateException("The \"File\" option must be set.");
        }
        if (this.maxIndex < this.minIndex) {
            this.addWarn("MaxIndex (" + this.maxIndex + ") cannot be smaller than MinIndex (" + this.minIndex + ").");
            this.addWarn("Setting maxIndex to equal minIndex.");
            this.maxIndex = this.minIndex;
        }
        if (this.maxIndex - this.minIndex > MAX_WINDOW_SIZE) {
            this.addWarn("Large window sizes are not allowed.");
            this.maxIndex = this.minIndex + MAX_WINDOW_SIZE;
            this.addWarn("MaxIndex reduced to " + this.maxIndex);
        }
        if ((itc = this.fileNamePattern.getIntegerTokenConverter()) == null) {
            throw new IllegalStateException("FileNamePattern [" + this.fileNamePattern.getPattern() + "] does not contain a valid IntegerToken");
        }
        this.compressor = new Compressor(this.compressionMode);
        this.compressor.setContext(this.context);
    }

    public void rollover() throws RolloverFailure {
        if (this.maxIndex >= 0) {
            File file = new File(this.fileNamePattern.convertInt(this.maxIndex));
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.maxIndex - 1; i >= this.minIndex; --i) {
                String toRenameStr = this.fileNamePattern.convertInt(i);
                File toRename = new File(toRenameStr);
                if (toRename.exists()) {
                    this.util.rename(toRenameStr, this.fileNamePattern.convertInt(i + 1));
                    continue;
                }
                this.addInfo("Skipping roll-over for inexistent file " + toRenameStr);
            }
            switch (this.compressionMode) {
                case NONE: {
                    this.util.rename(this.getActiveFileName(), this.fileNamePattern.convertInt(this.minIndex));
                    break;
                }
                case GZ: 
                case ZIP: {
                    this.compressor.compress(this.getActiveFileName(), this.fileNamePattern.convertInt(this.minIndex));
                }
            }
        }
    }

    public String getActiveFileName() {
        return this.getParentsRawFileProperty();
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }
}

