// OggChecker.h
// 2008/11/18

#pragma once

using namespace System;
using namespace System::IO;

namespace QOgg {

// Checker
public ref class Checker {

	Reader^ m_reader;

	UInt32 m_SerialNo;

	array<Byte>^ m_id;
	array<Byte>^ m_comm;
	array<Byte>^ m_setup;

	array<Byte>^ m_pending;

	UInt32 m_Flags;
	UInt64 m_GranulePosition;

	array<array<Byte>^>^ m_Packets;

public:

	Checker(Stream^ s)
	{
		m_reader = gcnew Reader(s);

		m_SerialNo = 0;

		m_id    = nullptr;
		m_comm  = nullptr;
		m_setup = nullptr;
	}

	property array<Byte>^ Id {
		array<Byte>^ get() { return m_id; }
	}

	property array<Byte>^ Setup {
		array<Byte>^ get() { return m_setup; }
	}

	property UInt32 Flags {
		UInt32 get() { return m_Flags; }
	}

	property UInt64 GranulePosition {
		UInt64 get() { return m_GranulePosition; }
	}

	property array<array<Byte>^>^ Packets {
		array<array<Byte>^>^ get() { return m_Packets; }
	}

	void ReadSetup()
	{
		Header header = m_reader->ReadPageHeader();
		if (header.Packets == nullptr) {
			throw gcnew InvalidStream("Read.Id.Header");
		}

		m_SerialNo = header.BitStreamSerialNumber;

		for (Int32 i = 0; i < header.Packets->Length; i++) {
			array<Byte>^ packet = m_reader->ReadPacketPayload(header.Packets[i]);
			Byte by = packet[0];
			if (by == 0x01) {
				m_id = packet;
			} else {
				throw gcnew InvalidStream("Unknown.Packet.1");
			}
		}

		if (m_id == nullptr) {
			throw gcnew InvalidStream("Missing.Id.Header");
		}

		for (; ; ) {
			header = m_reader->ReadPageHeader();
			if (header.Packets == nullptr) {
				throw gcnew InvalidStream("Read.Setup");
			}

			if (header.BitStreamSerialNumber != m_SerialNo) {
				throw gcnew InvalidStream("Invalid.BitStreamSerialNumber");
			}

			for (Int32 i = 0; i < header.Packets->Length; i++) {
				array<Byte>^ packet = m_reader->ReadPacketPayload(header.Packets[i]);
				if (i == 0 && (header.HeaderType & QOgg::Header::HT_Continue) != 0) {
					packet = Combine(packet);
				}

				Byte by = packet[0];

				if (by == 0x03) {
					m_comm = packet;
				} else if (by == 0x05) {
					m_setup = packet;
				} else {
					throw gcnew InvalidStream("Unknown.Packet.2+");
				}
			}

			if (header.PendingPacketSize > 0) {
				m_pending = m_reader->ReadPacketPayload(header.PendingPacketSize);
			} else {
				m_pending = nullptr;
			}

			if (m_comm != nullptr && m_setup != nullptr) {
				break;
			}
		}
	}

	bool ReadPage()
	{
		Header header = m_reader->ReadPageHeader();
		if (header.Packets == nullptr) {
			return false;
		}

		m_Flags = header.HeaderType;

		m_GranulePosition = header.GranulePosition;

		m_Packets = gcnew array<array<Byte>^>(header.Packets->Length);

		for (Int32 i = 0; i < header.Packets->Length; i++) {
			array<Byte>^ packet = m_reader->ReadPacketPayload(header.Packets[i]);
			if (i == 0 && (header.HeaderType & QOgg::Header::HT_Continue) != 0) {
				packet = Combine(packet);
			}

			m_Packets[i] = packet;
		}

		if (header.PendingPacketSize > 0) {
			m_pending = m_reader->ReadPacketPayload(header.PendingPacketSize);
		} else {
			m_pending = nullptr;
		}

		return true;
	}

private:

	array<Byte>^ Combine(array<Byte>^ buf)
	{
		if (m_pending == nullptr) {
			return buf;
		}

		array<Byte>^ newBuf = gcnew array<Byte>(m_pending->Length + buf->Length);

		Buffer::BlockCopy(m_pending, 0, newBuf, 0,                 m_pending->Length);
		Buffer::BlockCopy(buf,       0, newBuf, m_pending->Length, buf->Length      );

		return newBuf;
	}

}; // Checker

} // namespace QOgg

