/* TTAReader.h */
/* 2009/08/18  */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

struct QTTA_Format {

	INT32 SamplingRate;
	INT32 Channels;
	INT64 Duration;

}; /* QTTA_Format */

typedef struct QTTA_Format QTTA_Format_t;

/* */

struct QTTA_Reader;

typedef struct QTTA_Reader QTTA_Reader_t;

QTTA_Reader_t* QTTA_CreateReader(void);

void QTTA_ReleaseReader(QTTA_Reader_t* t);

BOOL QTTA_OpenReader(
	QTTA_Reader_t* t,
	const WCHAR*   path);

BOOL QTTA_OpenReader_IStream(
	QTTA_Reader_t* t,
	IStream*       p);

const QTTA_Format_t* QTTA_GetFormat(
	QTTA_Reader_t* t);

BOOL QTTA_Seek(
	QTTA_Reader_t* t,
	INT64          sample);

BOOL QTTA_Decode(
	QTTA_Reader_t* t,
	VOID*          buffer,
	INT32          samples,
	INT32*         output);

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

