/* OggReader.h */
/* 2009/07/22  */

#pragma once

/* */

#include "Utils.h"

/* */

INT32 QO_ScanCapturePattern(
	const VOID* pv,
	SIZE_T      cb);

/* */

struct QO_OggHeader {

	UINT64 GranulePosition;

	UINT8  HeaderType;

	UINT32 StreamSerialNumber;
	UINT32 PageSequenceNumber;

	UINT32 CRC32;

}; /* QO_OggHeader */

typedef struct QO_OggHeader QO_OggHeader_t;

/* */

struct QO_OggReader {

	QO_StreamReader_t* Reader;

	UINT8* Buffer;
	SIZE_T Size;

	SIZE_T Pointer;
	SIZE_T Filled;

	UINT8* Header;

	INT32   Packets;
	SIZE_T* PacketsSize;
	UINT8*  PacketsBuffer;

	BOOL Discontinue;

	UINT8* Payload;
	SIZE_T PayloadSize;

}; /* QO_OggReader */

typedef struct QO_OggReader QO_OggReader_t;

/* */

BOOL QO_OggReader_Init(
	QO_OggReader_t*    t,
	QO_MemoryPool_t*   pool,
	QO_Allocator_t*    allocator,
	QO_StreamReader_t* reader);

/* */

BOOL QO_OggReader_ReadHeader(
	QO_OggReader_t* t,
	QO_OggHeader_t* header);

BOOL QO_OggReader_ReadPayload(
	QO_OggReader_t* t);

BOOL QO_OggReader_SkipPayload(
	QO_OggReader_t* t);

/* */

BOOL QO_OggReader_Seek(
	QO_OggReader_t* t,
	INT64           pos);

/* */

