/*
 *  psychlops_FFTW_bridge.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2010/03/05 by Kenchi HOSOKAWA
 *  (C) 2010 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */


#include "../../../psychlops_core.h"
#include "psychlops_cv1_bridge.h"
#include <opencv/cv.h>


using namespace Psychlops;

void putIPLImage(IplImage *img) {
	std::cout << img->nSize << std::endl;
	std::cout << img->ID << std::endl;
	std::cout << img->nChannels << std::endl;
	std::cout << img->alphaChannel << std::endl;
	std::cout << img->depth << std::endl;
	// std::cout << img->colorModel[4] << std::endl;
	// std::cout << img->channelSeq[4] << std::endl;
	std::cout << img->dataOrder << std::endl;
	std::cout << img->origin << std::endl;
	std::cout << img->align << std::endl;
	std::cout << img->width << std::endl;
	std::cout << img->height << std::endl;
	//    struct _IplROI *roi << std::endl;
	//    struct _IplImage *maskROI << std::endl;
	//    void  *imageId << std::endl;
	//    struct _IplTileInfo *tileInfo << std::endl;
	std::cout << img->imageSize << std::endl;
	//    char *imageData << std::endl;
	std::cout << img->widthStep << std::endl;
	// std::cout << img->BorderMode[4] << std::endl;
	// std::cout << img->BorderConst[4] << std::endl;
	//    char *imageDataOrigin << std::endl;
}

IplImage formatIPLImageByPImage(Image &img) {
	IplImage iplimg;

	iplimg.nSize = sizeof(IplImage);
	iplimg.ID = 0;
	//iplimg.colorModel = NULL;
	//iplimg.channelSeq = NULL;
	iplimg.roi = NULL;
	iplimg.maskROI = NULL;
	iplimg.imageId = NULL;
	iplimg.tileInfo = NULL;
	//iplimg.BorderMode = NULL;
	//iplimg.BorderConst = NULL;

	switch(img.getComponentKind()) {
		case Image::GRAY:
			iplimg.nChannels = 1;
			break;
		case Image::RGB:
			iplimg.nChannels = 3;
			break;
		case Image::RGBA:
			iplimg.nChannels = 4;
			break;
	}
	switch(img.getPrecisionKind()) {
		case Image::BYTE:
			iplimg.depth = 8;
			break;
	}
	iplimg.alphaChannel = 0;
	iplimg.dataOrder = 0;
	iplimg.origin = 0;
	iplimg.align = 4;
	iplimg.width = img.getWidth();
	iplimg.height = img.getHeight();
	iplimg.widthStep = img.getLineBytes();
	iplimg.imageSize = iplimg.widthStep * iplimg.height;

	return iplimg;
}

IplImage adaptPImageToIPLImage(Image &img) {
	IplImage iplimg = formatIPLImageByPImage(img);

	iplimg.imageData = (char*)img.getElementPtr();
	iplimg.imageDataOrigin = (char*)img.getElementPtr();

	return iplimg;
}

IplImage *convertPImageToIplImage(Image &source) {
    IplImage* target;

	int widthStep;
	char *img;
	char pix[4];
	Color c;

	switch(source.getComponentKind()) {
		case Image::GRAY:
			target = cvCreateImage(cvSize(source.getWidth(), source.getHeight()), IPL_DEPTH_8U, 1 );
			widthStep = target->widthStep;
			img = target->imageData;
			for(int y=0; y<source.getHeight(); y++) {
				for(int x=0; x<source.getWidth(); x++) {
					c = source.getPix(x,y);
					img[widthStep * y + x] = (unsigned char)(c.getR()*255.0+.5);
				}
			}
			break;
		case Image::RGB:
			target = cvCreateImage(cvSize(source.getWidth(), source.getHeight()), IPL_DEPTH_8U, 3 );
			widthStep = target->widthStep;
			img = target->imageData;
			for(int y=0; y<source.getHeight(); y++) {
				for(int x=0; x<source.getWidth(); x++) {
					c = source.getPix(x,y);
					img[widthStep * y + x * 3    ] = (unsigned char)(c.getB()*255.0+.5);
					img[widthStep * y + x * 3 + 1] = (unsigned char)(c.getG()*255.0+.5);
					img[widthStep * y + x * 3 + 2] = (unsigned char)(c.getR()*255.0+.5);
				}
			}
			break;
		case Image::RGBA:
			target = cvCreateImage(cvSize(source.getWidth(), source.getHeight()), IPL_DEPTH_8U, 4 );
			widthStep = target->widthStep;
			img = target->imageData;
			for(int y=0; y<source.getHeight(); y++) {
				for(int x=0; x<source.getWidth(); x++) {
					c = source.getPix(x,y);
					img[widthStep * y + x * 4    ] = (unsigned char)(c.getB()*255.0+.5);
					img[widthStep * y + x * 4 + 1] = (unsigned char)(c.getG()*255.0+.5);
					img[widthStep * y + x * 4 + 2] = (unsigned char)(c.getR()*255.0+.5);
					img[widthStep * y + x * 4 + 3] = (unsigned char)(c.getA()*255.0+.5);
				}
			}
			break;
		default:
			break;
	}
	return target;
}

void convertIplImageToPImage(IplImage *source, Image &target) {
	int widthStep = source->widthStep;
	int lineBytes;
	unsigned char *img_b = (unsigned char *)source->imageData;
	unsigned char *img = img_b;
	unsigned char *timg;
	unsigned char *timg_b;
	unsigned char pix[4];
	Color c;

	switch(source->nChannels) {
		case 1:
			if(target.getComponentKind() != Image::GRAY || target.getWidth() != source->width || target.getHeight() != source->height ) {
				target.release();
				target.set(source->width, source->height, Image::GRAY);
			}
			lineBytes = target.getLineBytes();
			timg_b = target.getElementPtr();
			for(int y=0; y<target.getHeight(); y++) {
				img = img_b + widthStep*y;
				timg = timg_b + lineBytes*((source->height-y)-1);
				for(int x=0; x<target.getWidth(); x++) {
					*(timg++) = (unsigned char)img[0];
					img += 1;
				}
			}
			break;
		case 3:
			if(target.getComponentKind() != Image::RGB || target.getWidth() != source->width || target.getHeight() != source->height) {
				target.release();
				target.set(source->width, source->height, Image::RGB);
			}
			lineBytes = target.getLineBytes();
			timg_b = target.getElementPtr();
			for(int y=0; y<target.getHeight(); y++) {
				img = img_b + widthStep*y;
				timg = timg_b + lineBytes*((source->height-y)-1);
				for(int x=0; x<target.getWidth(); x++) {
					*(timg++) = (unsigned char)img[2];
					*(timg++) = (unsigned char)img[1];
					*(timg++) = (unsigned char)img[0];
					img += 3;
				}
			}
			break;
		case 4:
			if(target.getComponentKind() != Image::RGBA || target.getWidth() != source->width || target.getHeight() != source->height) {
				target.release();
				target.set(source->width, source->height, Image::RGBA);
			}
			lineBytes = target.getLineBytes();
			timg_b = target.getElementPtr();
			for(int y=0; y<target.getHeight(); y++) {
				img = img_b + widthStep*y;
				timg = timg_b + lineBytes*((source->height-y)-1);
				for(int x=0; x<target.getWidth(); x++) {
					*(timg++) = (unsigned char)img[2];
					*(timg++) = (unsigned char)img[1];
					*(timg++) = (unsigned char)img[0];
					*(timg++) = (unsigned char)img[3];
					img += 4;
				}
			}
			break;
		default:
			break;
	}


	/* This code works (at least)
	switch(source->nChannels) {
		case 1:
			if(target.getComponentKind() != Image::GRAY || target.getWidth() != source->width || target.getHeight() != source->height ) {
				target.release();
				target.set(source->width, source->height, Image::GRAY);
			}
			for(int y=0; y<target.getHeight(); y++) {
				for(int x=0; x<target.getWidth(); x++) {
					pix[0] = (unsigned char)img[widthStep * y + x];
					target.pix_direct(x,y, c.set(pix[0]/255.0));
				}
			}
			break;
		case 3:
			if(target.getComponentKind() != Image::RGB || target.getWidth() != source->width || target.getHeight() != source->height) {
				target.release();
				target.set(source->width, source->height, Image::RGB);
			}
			for(int y=0; y<target.getHeight(); y++) {
				for(int x=0; x<target.getWidth(); x++) {
					pix[0] = (unsigned char)img[widthStep * y + x * 3];
					pix[1] = (unsigned char)img[widthStep * y + x * 3 + 1];
					pix[2] = (unsigned char)img[widthStep * y + x * 3 + 2];
					target.pix_direct(x,y, c.set(pix[2]/255.0, pix[1]/255.0, pix[0]/255.0));
				}
			}
			break;
		case 4:
			if(target.getComponentKind() != Image::RGBA || target.getWidth() != source->width || target.getHeight() != source->height) {
				target.release();
				target.set(source->width, source->height, Image::RGBA);
			}
			for(int y=0; y<target.getHeight(); y++) {
				for(int x=0; x<target.getWidth(); x++) {
					pix[0] = (unsigned char)img[widthStep * y + x * 4];
					pix[1] = (unsigned char)img[widthStep * y + x * 4 + 1];
					pix[2] = (unsigned char)img[widthStep * y + x * 4 + 2];
					pix[3] = (unsigned char)img[widthStep * y + x * 4 + 3];
					target.pix_direct(x,y, c.set(pix[2]/255.0, pix[1]/255.0, pix[0]/255.0, pix[3]/255.0));
				}
			}
			break;
		default:
			break;
	}
	*/


	/* Imcompatible between RGBA and BGRA
	switch(source->nChannels) {
		case 1:
			if(target.getComponentKind() != Image::GRAY || target.getWidth() != source->width || target.getHeight() != source->height ) {
				target.release();
				target.set(source->width, source->height, Image::GRAY);
			}
			break;
		case 3:
			if(target.getComponentKind() != Image::RGB || target.getWidth() != source->width || target.getHeight() != source->height ) {
				target.release();
				target.set(source->width, source->height, Image::GRAY);
			}
			break;
		case 4:
			if(target.getComponentKind() != Image::RGBA || target.getWidth() != source->width || target.getHeight() != source->height ) {
				target.release();
				target.set(source->width, source->height, Image::GRAY);
			}
			break;
		default:
			break;
	}
	lineBytes = target.getLineBytes();
	timg = target.getElementPtr() + lineBytes*(source->height-1);
	for(int y=0; y<target.getHeight(); y++) {
		memcpy(timg, img, widthStep);
		img += widthStep;
		timg -= lineBytes;
	}
	*/
}



namespace Psychlops {
/*
	void Image::to(IplImage *target) const
	{
		target = convertPImageToIplImage(*this);
	}

	void Image::from(IplImage &source)
	{
		convertIplImageToPImage(&source, *this);
	}
*/

}	/*	<- namespace Psycholops 	*/
