/*
 *  psychlops_g_JPEG_bridge.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/22 by Kenchi HOSOKAWA
 *  (C) 2006- Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_IMAGE_FORMATS_JPEG
#define HEADER_PSYCHLOPS_IMAGE_FORMATS_JPEG


#include <stdio.h>
#include <stdlib.h>
extern "C" {
#include "jpeglib.h"
}

#include "../../../core/graphic/psychlops_g_image.h"


namespace Psychlops {
namespace IMAGE_FORMATS {


	const unsigned int JPEG_BYTES_TO_CHECK = 4;
	class JPEG_BRIDGE : public IMAGE_FORMAT {
		private:
		FILE *fp;
		bool is_opened_;

		// JPEG specific
		struct jpeg_decompress_struct cinfo;
		struct jpeg_error_mgr jerr;

		public:
		JPEG_BRIDGE();
		virtual ~JPEG_BRIDGE();
		virtual void load(const char *file_name, Image * target);
		virtual void save(const char *file_name, Image * target);

		private:
		void open(const char *file_name, const char *mode);
		void close();
		void check_before_read();
		void read(Image * target);
		void prepare_before_write();
		void write(Image * target);

	};


}
}

#endif
