# XSTORMY16 startup code for GDB stub.

# CPU Data for Sanyo EVA debugger at 0x7F00
        .section .cpudata,"ax"
        .byte   0x00,0x02,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x44,0x35,0x39,0x52,0x30,0x30,0x30,0x30,0x2E,0x4F,0x50,0x54,0x00,0x00,0x00,0x00
        .byte   0x4c,0x43,0x35,0x39,0x52,0x30,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x80,0x00,0x20,0x48,0x00,0x00,0x00
        .byte   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x20,0x01,0x12,0x31,0x23,0x59

# Interrupt vectors at 0x8000.
	.section .int_vec,"ax"
	.global	_start
	.align 1
_start:
	;; Reset, watchdog timer interrupt
	jmpf _int_reset
	;; base timer interrupt
	jmpf _int_basetimer
	;; timer 0
	jmpf _int_timer0
	;; timer 1
	jmpf _int_timer1
	;; SIO0 interrupt
	jmpf _int_sio0
	;; SIO1 interrupt
	jmpf _int_sio1
	;; port0 interrupt
	jmpf _int_port0
	;; port1 interrupt
	jmpf _int_port1

	.org 0x80
	;; sys interrupt (0x8080)
	jmpf _int_sys

	;; Application void write(char *buf, int nbytes)
	;; This jmps to a stub function to packetize the buf for GDB
	jmpf gdb_write
	;; Application int read(char *buf, int nbytes)
	jmpf gdb_read

	.text
# Reset code, set up memory and call main.
_int_reset:
	;; Set up the application stack pointer.
	mov sp,#0x002

	;; Zero the data space
	mov r0,#_edata
	mov r1,#_end
	mov r2,#0
0:	mov.w (r0++),r2
	blt r0,r1,0b

	;; Init the UART
	callf uart_init

	;; Turn on illegal insn trap
	mov   r0,r14
	set1  r0,#11
	mov   r14,r0
	mov.b 0x7f08,#0x11
	mov.b 0x7f09,#0x10

	;; "breakpoint" sends us into stub.
0:
	.hword 0x0006
	br  0b

1:	.size _int_reset,1b-_int_reset
		
# Stub interrupt routines.
	.globl _int_timer0
	.weak _int_timer0
	.globl _int_timer1
	.weak _int_timer1
	.globl _int_sio0
	.weak _int_sio0
	.globl _int_sio1
	.weak _int_sio1
	.globl _int_port0
	.weak _int_port0
	.globl _int_port1
	.weak _int_port1
	.globl _int_basetimer
	.weak _int_basetimer
_int_timer0:
_int_timer1:
_int_sio0:
_int_sio1:
_int_port0:
_int_port1:
_int_basetimer:
	iret
1:	.size _int_timer0,1b-_int_timer0

_int_sys:
	push  r13
	mov   r13,#registers
	mov.w (r13++),r0
	mov.w (r13++),r1
	mov.w (r13++),r2
	mov.w (r13++),r3
	mov.w (r13++),r4
	mov.w (r13++),r5
	mov.w (r13++),r6
	mov.w (r13++),r7
	mov   r0,r8
	mov.w (r13++),r0
	mov   r0,r9
	mov.w (r13++),r0
	mov   r0,r10
	mov.w (r13++),r0
	mov   r0,r11
	mov.w (r13++),r0
	mov   r0,r12
	mov.w (r13++),r0
	pop   r0
	mov.w (r13++),r0    ; R13
	pop   r0
	mov.w (r13++),r0    ; PSW
	mov   r0,r15
	sub   r0,#4
	mov.w (r13++),r0    ; SP
	pop   r0
	pop   r1
	mov.w (r13++),r1    ; PCL
	mov.w (r13++),r0    ; PCH

	;; switch to stub stack and invoke stub
	mov sp,#0x700
	callf handle_exception

	mov   r0,#registers+34
	mov.w r1,(r0)		; PCH
	mov.w r2,(--r0)		; PCL
	mov.w r3,(--r0)		; SP
	mov   r15,r3
	push  r2
	push  r1
	mov.w r1,(--r0)    ; PSW
	push  r1
	mov.w r1,(--r0)
	mov   r13,r1
	mov.w r1,(--r0)
	mov   r12,r1
	mov.w r1,(--r0)
	mov   r11,r1
	mov.w r1,(--r0)
	mov   r10,r1
	mov.w r1,(--r0)
	mov   r9,r1
	mov.w r1,(--r0)
	mov   r8,r1
	mov.w r7,(--r0)
	mov.w r6,(--r0)
	mov.w r5,(--r0)
	mov.w r4,(--r0)
	mov.w r3,(--r0)
	mov.w r2,(--r0)
	mov.w r1,(--r0)
	mov.w r0,(--r0)
	iret
1:	.size _int_sys,1b-_int_sys


