﻿#ifndef	_MOD_H__000314_1610		/* ２重インクルード防止の番兵 */
#define	_MOD_H__000314_1610
#include "_allinc2.h"

#define		MAX_PATTERNS				( 256 )
#define		MAX_INSTRUMENTS				( 128 )
#define		MAX_SAMPLES_IN_INSTRUMENT	( 16 )
#define		MAX_SAMPLES					( MAX_INSTRUMENTS * MAX_SAMPLES_IN_INSTRUMENT )
#define		MAX_CHANNELS				( 64 )


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	構造体の型
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/



/* インストゥールメントのエンベロープ制御点 */
struct ENVELOPE {
	U16		x ;						/* エンベロープ制御点の x 座標 */
	U16		y ;						/* エンベロープ制御点の y 座標 */
};

/* 演奏中の曲の状態を表す */
#pragma pack(push)
#pragma pack(1)
struct MOD {
	S32	FormatType ;			/* フォーマットタイプ */

	S32	bLoopMode ;				/* ループ再生モードか？ TRUE / FALSE */
	S32	bAutoGainControl ;		/* 自動ゲインコントロールするか？ TRUE / FALSE */
	S32	bDone ;					/* 再生終了したか？ TRUE / FALSE */

	S32	TickCount ;				/* テンポ処理用 */
	S32	nTickPerRow ;			/* テンポ処理用（1 Row あたりの tick 数）*/
	S32	BPM ;					/* BPM */
	S32	nWavePerSec ;			/* WAVE 出力デバイスの周波数(Hz) */
	S32	nWavePerTick ;			/* 最小割り込み単位期間当たりの生成波形数 */
	S32	nRestWave ;				/* 次の割り込みまでの残存波形データ数 */

	S32	Row ;					/* パターンデータ内スキャン位置 */
	S32	BreakSequence ;			/* 分岐先（Sequence）*/
	S32	BreakRow ;				/* 分岐先（Row）*/
	S32	PatternDelay ;			/* コマンド EEx 用遅延数（Row 単位） */
	S32	FinePatternDelay ;		/* コマンド X6x 用遅延数（Tick 単位） */

	S32	idxSequenceData ;		/* シーケンスデータ読み取り位置 */

	S32	GlobalVolume_ ;			/* グローバルボリューム（0x00_ ～ 0x40_）*/
	S32	GlobalVolumeSlide ;		/* グローバルボリューム、スライド値 */
	S32	GlobalVolumeScale_ ;	/* 全体の音量スケーリング値（0_ ～ 1_）*/
	S32	GainControlScale_ ;		/* ゲイン調整用 音量スケーリング値（0_ ～ 1_）*/

	/* プチノイズ対策 */
	S32	AntiNoiseVal_L ;		/* 波形の修正値、左 */
	S32	AntiNoiseVal_R ;		/* 波形の修正値、右 */

	/* XM 形式 ヘッダー情報 その１ */
	struct XM_ID {
		char	aszID_Text[ 17 ];		/* XM 形式識別文字列 */
		char	aszModuleName[ 21 ];	/* データの名前（1文字余分に）*/
		S32		ID_Byte ;				/* XM 形式識別用 */
		char	aszTrackerName[ 21 ];	/* 本データを作成したトラッカー名（1文字余分に）*/
		S32		VersionNumber ;			/* データのバージョンナンバー */
	} XmId ;

	/* XM 形式 ヘッダー情報 その２ */
	struct XM_HEADER {
		S32		HeaderSize ;			/* ヘッダー領域のサイズ */
		S32		SongLength ;			/* aPatternOrderTable の長さに換算した、曲の全長 */
		S32		RestartPosition ;		/* 曲のループ時、復帰位置 */
		S32		NumberOfChannels ;		/* 総チャンネル数 */
		S32		NumberOfPatterns ;		/* 総 Pattern 数 */
		S32		NumberOfInstruments ;	/* 総 Instrument 数 */
		S32		Flags ;					/*
											bit 0 :	0 なら AmigaPeriod モード
													1 なら 線形周波数モード
										*/
		S32		DefaultTempo ;			/* 1 Row 当りの Tick 数、デフォルト値 */
		S32		DefaultBPM ;			/* BPM デフォルト値 */
		U8		aPatternOrderTable[ 256 ];	/* 演奏する Pattern の順序を表したテーブル */
	} XmHeader ;

	/* パターンの情報 */
	struct XM_PATTERN {
		S32		PatternHeaderLength ;	/* ヘッダー領域のサイズ */
		S32		PackingType ;			/* Pattern の圧縮形式（常に 0 らしい）*/
		S32		NumberOfRowsInPattern ;	/* Pattern 内の総 Row 数 */
		S32		PackedPatterndataSize ;	/* 圧縮された状態での Pattern のデータサイズ */

		/* ワーク領域 */
		U8		*pPatternData ;			/* パターンデータへのポインター */
	} *(apXM_PATTERN[ MAX_PATTERNS ]);

	/* サンプリングの情報 */
	struct XM_SAMPLE {
		void	*pSampleData ;			/* サンプリングデータへのポインター */
		S32		SampleLength ;			/* サンプリングデータの波形要素数 */
		S32		SampleLoopStart ;		/* サンプリングのループ開始位置（波形要素単位）*/
		S32		SampleLoopLength ;		/* サンプリングのループ区間の長さ（波形要素単位）*/
		S32		Volume ;				/* サンプリングのデフォルト音量 */
		S32		FineTune ;				/* サンプリングのデフォルト FineTune 値 */
		S32		Type ;					/*
											Bit 0-1:	00	= No loop
														01	= Forward loop
														10	= Ping-pong loop
											Bit 4:		 0	=  8-bit sampledata
														 1	= 16-bit sampledata
										*/
		S32		Panning ;				/* サンプリングのデフォルトパン位置 */
		S32		RelativeNoteNumber ;	/* 音階の修正値 */
		S32		Reserved ;				/* 予約領域 */
		char	aszSampleName[23];		/* サンプリングの名前（1文字余分に）*/

		/* ワーク領域 */
		S32		VoiceMode ;				/* 各種フラグ */
	} *(apXM_SAMPLE[ MAX_SAMPLES ]);

	/* インストゥールメントの情報 */
	struct XM_INSTRUMENT {
		S32			InstrumentSize ;				/* データサイズ */
		char		aszInstrumentName[ 23 ];		/* インストゥールメントの名前（1文字余分に）*/
		S32			InstrumentType ;				/* インストゥールメントの形式（常に 0 らしい）*/
		S32			NumberOfSamplesInInstrument ;	/* このインストゥールメントに含まれるサンプリング数 */
		S32			SampleHeaderSize ;				/* サンプリングのヘッダー情報のサイズ */
		U8			aSampleNumberForAllNotes[ 96 ];	/* 全音階別のサンプリング番号 */
		ENVELOPE	aPointsForVolumeEnvelope[ 12 ];		/* ボリュームエンベロープの制御点（最大 12）*/
		ENVELOPE	aPointsForPanningEnvelope[ 12 ];	/* パンエンベロープの制御点（最大 12）*/
		S32			NumberOfVolumePoints ;			/* ボリュームエンベロープの制御点の数 */
		S32			NumberOfPanningPoints ;			/* パンエンベロープの制御点の数 */
		S32			VolumeSustainPoint ;			/* ボリュームエンベロープのサステインポイント */
		S32			VolumeLoopStartPoint ;			/* ボリュームエンベロープのループ開始位置 */
		S32			VolumeLoopEndPoint ;			/* ボリュームエンベロープのループ終了位置 */
		S32			PanningSustainPoint ;			/* パンエンベロープのサステインポイント */
		S32			PanningLoopStartPoint ;			/* パンエンベロープのループ開始位置 */
		S32			PanningLoopEndPoint ;			/* パンエンベロープのループ終了位置 */
		S32			VolumeType ;					/*
														bit 0:	0 = エンベロープ OFF
																1 = エンベロープ ON
															1:	0 = サステイン OFF
																1 = サステイン ON
															2:	0 = ループ OFF
																1 = ループ ON
													*/
		S32			PanningType ;					/*
														bit 0:	0 = エンベロープ OFF
																1 = エンベロープ ON
															1:	0 = サステイン OFF
																1 = サステイン ON
															2:	0 = ループ OFF
																1 = ループ ON
													*/
		S32			AutoVibratoType ;				/* 自動ビブラート、波形種類 */
		S32			AutoVibratoSweep ;				/* 自動ビブラート、MAX 振幅に到達するまでの Tick 数 */
		S32			AutoVibratoDepth ;				/* 自動ビブラート、MAX 振幅 */
		S32			AutoVibratoRate ;				/* 自動ビブラート、振動速度 */
		S32			VolumeFadeout ;					/* KeyOff 時のフェードアウト速度 */
		S32			Reserved ;						/* 予約領域 */

		/* ワーク領域 */
		XM_SAMPLE	*apAllNoteXM_SAMPLE[ 96 ];		/* 全音階別サンプリング情報へのポインター */
		U8			VolumeEnvelopeTable[ 325 ];		/* 展開済みの、ボリュームエンベロープ */
		U8			PanningEnvelopeTable[ 325 ];	/* 展開済みの、パンエンベロープ */
	} *(apXM_INSTRUMENT[ MAX_INSTRUMENTS ]);

	/* 各チャンネルの状態 */
	struct CHANSTAT {
		/* 現在の Row の内容（NoteDelay の遅延読み込みを考慮）*/
		S32	idxNowPatternNote ;
		S32	idxNowRealNote ;
		S32	NowVolumeColumn ;
		S32	NowCommand ;
		S32	NowParam ;
		S32	NowPeriod_ ;
		S32	idxNowInst ;

		/* インストゥールメント情報へのポインター */
		XM_INSTRUMENT	*pPendingXM_INSTRUMENT ;
		XM_INSTRUMENT	*pPlayingXM_INSTRUMENT ;

		/* サンプリング情報へのポインター */
		XM_SAMPLE		*pPlayingXM_SAMPLE ;

		/* 最後に押されたキー番号 */
		S32	idxLastRealNote ;

		/* period 関係 */
		S32	PendingPeriod_ ;
		S32	PlayingPeriod_ ;
		S32	FinalPeriod_ ;
		S32	PeriodLowLimit_ ;			/* 下限 */
		S32	PeriodHighLimit_ ;			/* 上限 */

		/* FineTune 関係 */
		S32	PlayingFineTune ;

		/* 音量関係 */
		S32	PlayingVolume_ ;			/*（0x00_ ～ 0x40_）*/
		S32	FinalVolume_ ;				/*（0x00_ ～ 0x40_）*/
		S32	FinalVolume_L_ ;			/*（0x00_ ～ 0x40_）*/
		S32	FinalVolume_R_ ;			/*（0x00_ ～ 0x40_）*/
		S32	VolumeSlide ;				/* 音量スライド値 */
		S32	FineVolumeSlide ;			/* 音量スライド値（FineVolumeSlide 用）*/
		S32	VolumeScale_ ;				/* チャンネル単位の音量スケーリング値（0_ ～ 1_）*/

		/* パン関係 */
		S32	PlayingPanning_ ;			/*（左:0x000_ ～ 0x0FF_:右）*/
		S32	FinalPanning_ ;				/*（左:0x000_ ～ 0x100_:右）*/
		S32	PanningSlide ;				/* パン スライド値（コマンド Pxy 用）*/

		/* エンベロープ関係 */
		S32	idxVolumeEnvelopeTable ;	/* ボリュームエンベロープのテーブル参照位置 */
		S32	idxPanningEnvelopeTable ;	/* パンエンベロープのテーブル参照位置 */

		/* Vibrato 関係 */
		S32	VibratoType ;				/* タイプ */
		S32	VibratoPosition_ ;			/* 波形位置 */
		S32	VibratoRate ;				/* 速度 */
		S32	VibratoDepth ;				/* 振幅 */

		/* Tremolo 関係 */
		S32	TremoloType ;				/* タイプ */
		S32	TremoloPosition_ ;			/* 波形位置 */
		S32	TremoloRate ;				/* 速度 */
		S32	TremoloDepth ;				/* 振幅 */

		/* Portamento 関係 */
		S32	PortamentoInc ;				/* period 加算量（Portamento 用）*/
		S32	TonePortamentoInc ;			/* period 加算量（Tone-Portamento 用）*/
		S32	TonePortamentoDst_ ;		/* period 目標値（Tone-Portamento 用）*/
		S32	FinePortamentoInc ;			/* period 加算量（Fine-Portamento 用）*/
		S32	ExtraFinePortamentoInc ;	/* period 加算量（Extra Fine-Portamento 用）*/

		/* Arpeggio 関係 */
		S32	ArpeggioPeriod_[2] ;
		S32	idxArpeggio ;				/* 0 -> 1 -> 2 繰り返し */

		/* Tremor（コマンド Txy）関係 */
		S32	TremorCount ;				/* カウンター */
		S32	TremorOnTime ;				/* KeyOn 期間（tick 数）*/
		S32	TremorOffTime ;				/* KeyOff 期間（tick 数）*/
		S32	bTremorMute ;				/* ミュート状態か？ TRUE / FALSE */

		/* Multi retrig（コマンド Rxy）関係 */
		S32	MultiRetrigCount ;			/* カウンター */
		S32	MultiRetrigInterval ;		/* 間隔 */
		S32	MultiRetrigVolumeChange ;	/* 音量の変化のさせ方 */

		/* Panbrello 関係 */
		S32	PanbrelloType ;				/* タイプ */
		S32	PanbrelloPosition ;			/* 波形位置 */
		S32	PanbrelloRate ;				/* 速度 */
		S32	PanbrelloDepth ;			/* 振幅 */

		/* Pattern loop（コマンド E6x）関係 */
		S32	PatternLoopCount ;			/* ループ回数カウント用 */
		S32	PatternLoopRow ;			/* ループポイント（Row）*/

		/* KEYOFF フェードアウト関係 */
		S32	bFadeOut ;					/* フェードアウト中？ TRUE / FALSE */
		S32	FadeOutVolume_1_15_16 ;		/* フェードアウト用、音量倍率（固定少数 16 bit）*/

		/* Auto-Vibrato 関係 */
		S32	AutoVibratoPosition ;		/* 波形位置 */
		S32	AutoVibratoDepth_ ;			/* 振幅 */

		/* Surround 関係 */
		S32	bSurround ;					/* Surround は有効か？ TRUE / FALSE */

		/* その他いろいろ */
		U32	SamplePosition_ ;			/* サンプリングの再生位置 */
		U32	SampleRate_ ;				/* サンプリングの再生レート */
		U32	SampleOffset ;				/* コマンド 9xx で指定したオフセット値（最後に指定した値）*/
		U32	SampleHighOffset ;			/* コマンド XAx で指定したオフセット値（最後に指定した値）*/
		S32	bGrissando ;				/* Grissando は有効か？ TRUE / FALSE */
		S32	VolumeColumnContinueValue ;	/* VolumeColumn 専用、特殊な continue 再現用 */

		/* プチノイズ対策 */
		XM_SAMPLE	*pLastPlayingXM_SAMPLE ;	/* 前回のサンプリング */
		U32	LastSamplePosition_ ;		/* 前回のサンプリングの再生位置 */
		S32	LastWaveVal_L ;				/* 波形の最終値、左 */
		S32	LastWaveVal_R ;				/* 波形の最終値、右 */
		S32	LastSampleVolume_L_ ;		/* 音量の最終値、左 */
		S32	LastSampleVolume_R_ ;		/* 音量の最終値、右 */
	} aCHANSTAT[ MAX_CHANNELS ];
	void* Instance;// NaCl インスタンス
};
#pragma pack(pop)

/* タグ名のフック */

typedef MOD::XM_ID			XM_ID ;
typedef MOD::XM_HEADER		XM_HEADER ;
typedef MOD::XM_PATTERN		XM_PATTERN ;
typedef MOD::XM_SAMPLE		XM_SAMPLE ;
typedef MOD::XM_INSTRUMENT	XM_INSTRUMENT ;
typedef MOD::CHANSTAT			CHANSTAT ;

/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	MOD データの読み込み

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__LoadSong(
	 MOD	*pMOD		/* this ポインター */
	,void	*pMusDat_	/* メモリ上にファイルを読み込み、そのポインターをここに指定 */
	,S32	 lMusDat	/* データサイズ */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	MOD データの破棄

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__ReleaseSong(
	 MOD	*pMOD		/* this ポインター */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	音量の設定

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__Set_Volume(
	 MOD	*pMOD		/* this ポインター */
	,S32	Volume		/* 音量 0 ～ 256（それ以上にも設定可能）*/
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	再生レートの設定

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__Set_nWavePerSec(
	 MOD	*pMOD			/* this ポインター */
	,S32	nWavePerSec		/* WAVE 出力デバイスの周波数(Hz) */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	ループ再生モード / 非ループ再生モード の指定

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__Set_bLoopMode(
	 MOD	*pMOD			/* this ポインター */
	,S32	bLoopMode		/* ループ再生モードか？ TRUE / FALSE */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	自動ゲインコントロールするかどうか の指定

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__Set_bAutoGainControl(
	 MOD	*pMOD				/* this ポインター */
	,S32	bAutoGainControl	/* 自動ゲインコントロールするか？ TRUE / FALSE */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	再生を初期化（内部パラメーターを初期化し、先頭から再生し直す）

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__InitPlay(
	 MOD	*pMOD		/* this ポインター */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	MOD データの再生

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__PlaySong(
	 MOD	*pMOD			/* this ポインター */
	,U32	*pWaveOutPut	/* 波形出力先（L R をひとまとめにして、U32 単位で出力する）*/
	,S32	 nWaveOutPut	/* 出力波形数 */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	MOD 構造体の破棄

	戻値・TRUE  = 成功
		・FALSE = 失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
S32 MOD__Destruct(
	MOD	*p		/* this ポインター */
);


/*━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━
▼	MOD 構造体の確保と初期化

	戻値：	確保した構造体へのポインター
			NULL なら失敗
━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━*/
MOD *MOD__Create(void*  Instance /* Naclインスタンス */
);
#endif
