<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractFilterForm.class.php';

define('SD2ND_COSTUME_SORT_KEY_COSTUME_ID', 1);
define('SD2ND_COSTUME_SORT_KEY_COSTUME_NAME', 2);
define('SD2ND_COSTUME_SORT_KEY_GROW_LIFE', 3);
define('SD2ND_COSTUME_SORT_KEY_GROW_SOUL', 4);
define('SD2ND_COSTUME_SORT_KEY_GROW_POW', 5);
define('SD2ND_COSTUME_SORT_KEY_GROW_STR', 6);
define('SD2ND_COSTUME_SORT_KEY_GROW_DEX', 7);
define('SD2ND_COSTUME_SORT_KEY_GROW_SPEED', 8);
define('SD2ND_COSTUME_SORT_KEY_GROW_MAG', 9);
define('SD2ND_COSTUME_SORT_KEY_GROW_REG', 10);
define('SD2ND_COSTUME_SORT_KEY_GROW_CON', 11);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_HP', 12);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_TP', 13);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_AT', 14);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_DF', 15);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_MAT', 16);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_MDF', 17);
define('SD2ND_COSTUME_SORT_KEY_MODIFY_ACT', 18);
define('SD2ND_COSTUME_SORT_KEY_MOVE_COST', 19);
define('SD2ND_COSTUME_SORT_KEY_REGIST_TIME', 20);
define('SD2ND_COSTUME_SORT_KEY_DEFAULT', SD2ND_COSTUME_SORT_KEY_COSTUME_ID);

/**
 * Sd2nd_CostumeFilterForm
**/
class Sd2nd_CostumeFilterForm extends Sd2nd_AbstractFilterForm
{
    /**
     * @var  string[]
     * 
     * @public
    **/
    var $mSortKeys = array(
        SD2ND_COSTUME_SORT_KEY_COSTUME_ID => 'costume_id',
        SD2ND_COSTUME_SORT_KEY_COSTUME_NAME => 'costume_name',
        SD2ND_COSTUME_SORT_KEY_GROW_LIFE => 'grow_life',
        SD2ND_COSTUME_SORT_KEY_GROW_SOUL => 'grow_soul',
        SD2ND_COSTUME_SORT_KEY_GROW_POW => 'grow_pow',
        SD2ND_COSTUME_SORT_KEY_GROW_STR => 'grow_str',
        SD2ND_COSTUME_SORT_KEY_GROW_DEX => 'grow_dex',
        SD2ND_COSTUME_SORT_KEY_GROW_SPEED => 'grow_speed',
        SD2ND_COSTUME_SORT_KEY_GROW_MAG => 'grow_mag',
        SD2ND_COSTUME_SORT_KEY_GROW_REG => 'grow_reg',
        SD2ND_COSTUME_SORT_KEY_GROW_CON => 'grow_con',
        SD2ND_COSTUME_SORT_KEY_MODIFY_HP => 'modify_hp',
        SD2ND_COSTUME_SORT_KEY_MODIFY_TP => 'modify_tp',
        SD2ND_COSTUME_SORT_KEY_MODIFY_AT => 'modify_at',
        SD2ND_COSTUME_SORT_KEY_MODIFY_DF => 'modify_df',
        SD2ND_COSTUME_SORT_KEY_MODIFY_MAT => 'modify_mat',
        SD2ND_COSTUME_SORT_KEY_MODIFY_MDF => 'modify_mdf',
        SD2ND_COSTUME_SORT_KEY_MODIFY_ACT => 'modify_act',
        SD2ND_COSTUME_SORT_KEY_MOVE_COST => 'move_cost',
        SD2ND_COSTUME_SORT_KEY_REGIST_TIME => 'regist_time'
    );

    /**
     * getDefaultSortKey
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function getDefaultSortKey()
    {
        return SD2ND_COSTUME_SORT_KEY_DEFAULT;
    }

    /**
     * fetch
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function fetch()
    {
        parent::fetch();
    
        $root =& XCube_Root::getSingleton();
    
        if (($value = $root->mContext->mRequest->getRequest('regist_time')) != null) {
            $this->_mCriteria->add(new Criteria('regist_time', $value));
        }
        $this->mNavi->addExtra('regist_time', $value);
    
        $this->_mCriteria->addSort($this->getSort(), $this->getOrder());
    }
}

?>
