<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_RaceListPrepare
**/
class Sd2nd_RaceListPrepare extends Sd2nd_AbstractFilter
{
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $root =& XCube_Root::getSingleton();
        $db =& $root->mController->mDB;
        $arr = array();
        
        if(!$res = $db->query('select `race_id`,`race_name` from `' . Sd2nd_UpdateUtils::convertTableName(Sd2nd_AssetManager::HANDLER_RACE) . '`'))
        {
            throw new Sd2nd_QueryException('Race data is not readable.');
        }
        
        while($row = $db->fetchArray($res))
        {
            $arr[$row['race_name']] = $row['race_id'];
        }
        
        $root->mContext->setAttribute('sd2nd.race',$arr);
    }
}

?>
