<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}

/**
 * @class   Sd2nd_MapCollectionPrepare
**/
class Sd2nd_MapCollectionPrepare extends Sd2nd_AbstractFilter
{
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_FINAL;
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $attr =& XCube_Root::getSingleton()->mContext->mAttributes;
        $attr['sd2nd.mapName'] = array();
        $attr['sd2nd.mapCollection'] = array();
        $mapHandler =& Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP);
        $update = Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_UPDATE)->getLatestUpdate();
        foreach(Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP_NAME)->getObjects() as $name)
        {
            $attr['sd2nd.mapName'][$name->get('map_name')] = $name;
            $attr['sd2nd.mapCollection'][$name->get('map_name')] = $mapHandler->getCollection(SD2ND_UPDATE_TIME,$update->get('update_time'),$name->get('map_id'));
        }
    }
    
    /**
     * execute090211
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute090211()
    {
        $update = Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_UPDATE)->getLatestUpdate();
        if($update == null)
        {
            $update = SD2ND_UPDATE_TIME;
        }
        XCube_Root::getSingleton()->mContext->setAttribute('sd2nd.mapCollection',Sd2nd_UpdateUtils::getHandler(Sd2nd_AssetManager::HANDLER_MAP)->getCollection(SD2ND_UPDATE_TIME,$update->get('update_time')));
    }
}

?>
