<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_Show_StatusCharParser
**/
class Sd2nd_Show_StatusCharParser extends Sd2nd_AbstractParser
{
    /**
     * @brief   XCube_HttpContext
    **/
    protected $_mContext = null;
    
    /**
     * @brief   int{}
    **/
    protected $_mElements = array();
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        parent::__construct();
        
        $root =& XCube_Root::getSingleton();
        $this->_mContext =& $root->mContext;
        
        $i = 0;
        while(defined($value = '_MD_SD2ND_LANG_ELEMENT_' . $i))
        {
            $this->_mElements[constant($value)] = $i++;
        }
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $arr = Sd2nd_UpdateUtils::parseByRegex($this->_mLine,"/\(\d+,'(?P<params>[\d,]+)','(?P<grows>[\d,]+)','(?P<nick_name>[^']+)','(?P<battle_name>[^']+)','(?P<profile>[^']+)','(?P<class>[^']+)Lv\.\d+','\d\/\d,(?P<ability>[^']+)','(?P<weapon>[^']+)'\)/");
        $params = Sd2nd_UpdateUtils::parseByExplode($arr['params'],13,0,null,array('lv','life','soul','pow','str','dex','speed','mag','reg','con','exp','money','sp'));
        $grows = Sd2nd_UpdateUtils::parseByExplode($arr['grows'],10,0,null,array('lv','life','soul','pow','str','dex','speed','mag','reg','con'));
        $elementBase = mb_substr($arr['profile'],0,1);
        $elementExtra = mb_substr($arr['profile'],2,1);
        $raceName = mb_substr($arr['profile'],4);
        $ability = explode(',',$arr['ability']);
        $weapon = explode(',',$arr['weapon']);
        
        if(!isset($this->_mContext->mAttributes['sd2nd.race'][$raceName]))
        {
            $race =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_RACE);
            $race->set('race_name',$raceName);
            Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_RACE,$race);
            $this->_mContext->mAttributes['sd2nd.race'][$raceName] = $race->get('race_id');
        }
        
        if(!isset($this->_mElements[$elementBase]))
        {
            throw new Sd2nd_Exception('Base element "' . $elementBase . '" is not defined.');
        }
        
        if(!isset($this->_mElements[$elementExtra]))
        {
            throw new Sd2nd_Exception('Base element "' . $elementExtra . '" is not defined.');
        }
        
        $this->_mExecute->mCharData[Sd2nd_AssetManager::HANDLER_CHAR]->setVars(array('nick_name' => $arr['nick_name'],'battle_name' => $arr['battle_name'],'race' => $this->_mContext->mAttributes['sd2nd.race'][$raceName],'element_base' => $this->_mElements[$elementBase],'element_ext' => $this->_mElements[$elementExtra]));
        $this->_mExecute->mCharData[Sd2nd_AssetManager::HANDLER_STATUS]->setVars($params);
        $this->_mExecute->mActiveCostume = $arr['class'];
        
        foreach($ability as $key => $val)
        {
            if($val != null)
            {
                $this->_mExecute->mActiveAbilities[$key + 1] = substr($val,0,strrpos($val,'('));
            }
        }
        
        $cnt = count($weapon);
        for($i = 1;$i < $cnt;$i++)
        {
            $weaponLv = array();
            if(preg_match('/^(?P<name>.+)Lv(?P<lv>\d+)$/',$weapon[$i],$weaponLv))
            {
                $this->_mExecute->mWeaponLv[] = $weaponLv;
            }
        }
    }
}


?>
