<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit();
}


/**
 * @class   Sd2nd_AbstractProcess
**/
abstract class Sd2nd_AbstractProcess
{
    /**
     * @breif   ReflectionMethod
    **/
    protected $_mFunc = null;
    
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
    }
    
    /**
     * prepare
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        $class = new ReflectionClass($this);
        $methods = $class->getMethods();
        usort($methods,array('Sd2nd_AbstractProcess','compareMethodName'));
        
        foreach($methods as $method)
        {
            if(substr($name = $method->name,0,7) == 'execute' && ctype_digit($date = substr($name,7)) && $date >= $updateTime)
            {
                $this->_mFunc = $method;
                break;
            }
        }
        
        if(!$this->_mFunc instanceof ReflectionMethod)
        {
            $this->_mFunc = new ReflectionMethod($this,'executeLatest');
        }
    }
    
    /**
     * compareMethodName
     * 
     * @param   ReflactionMethod    $a
     * @paramm  ReflectionMethod    $b
     * 
     * @return  bool
    **/
    public static function compareMethodName(ReflectionMethod $a,ReflectionMethod $b)
    {
        return ($a->name > $b->name);
    }
    
    /**
     * execute
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute()
    {
        $this->_mFunc->invoke($this);
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    abstract public function executeLatest();
}


/**
 * @class   Sd2nd_AbstractFilter
**/
abstract class Sd2nd_AbstractFilter extends Sd2nd_AbstractProcess
{
    /**
     * getPriority
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getPriority()
    {
        return XCUBE_DELEGATE_PRIORITY_NORMAL;
    }
}


/**
 * @class   Sd2nd_AbstractParser
**/
abstract class Sd2nd_AbstractParser extends Sd2nd_AbstractProcess
{
    /**
     * @brief   int
    **/
    protected $_mActiveId = null;
    
    /**
     * @brief   Sd2nd_AbstractExecute
    **/
    protected $_mExecute = null;
    
    /**
     * @brief   string
    **/
    protected $_mLine = null;
    
    /**
     * @brief   int
    **/
    protected $_mUpdateTime = null;
    
    /**
     * prepare
     * 
     * @param   int $updateTime
     * 
     * @return  void
    **/
    public function prepare(/*** int ***/ $updateTime)
    {
        parent::prepare($updateTime);
        $this->_mUpdateTime = $updateTime;
    }
    
    /**
     * reset
     * 
     * @param   int                     $id
     * @param   Sd2nd_AbstractExecute   &$execute
     * @param   string                  $line
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id,Sd2nd_AbstractExecute &$execute,/*** string ***/ $line)
    {
        $this->_mActiveId = $id;
        $this->_mExecute =& $execute;
        $this->_mLine = $line;
    }
}


/**
 * @class   Sd2nd_AbstractExecute
**/
abstract class Sd2nd_AbstractExecute extends Sd2nd_AbstractProcess
{
    /**
     * @brief   int
    **/
    protected $_mActiveId = null;
    
    /**
     * @brief   string
    **/
    protected $_mText = null;
    
    /**
     * @brief   string
    **/
    protected $_mParserPath = 'execute/parser';
    
    /**
     * @brief   string
    **/
    protected $_mFilterPattern = '/^(?P<name>\w+)/';
    
    /**
     * reset
     * 
     * @param   int     $id
     * @param   string  $text
     * 
     * @return  void
    **/
    public function reset(/*** int ***/ $id,/*** string ***/ $text)
    {
        $this->_mActiveId = $id;
        $this->_mText = $text;
    }
    
    /**
     * execute
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function execute()
    {
        $this->_mFunc->invoke($this);
        $this->_save();
    }
    
    /**
     * executeLatest
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    public function executeLatest()
    {
        $this->_parse();
    }
    
    /**
     * _parse
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _parse()
    {
        foreach(explode("\n",$this->_mText) as $line)
        {
            $arr = array();
            $line = trim($line);
            if(preg_match($this->_mFilterPattern,$line,$arr))
            {
                $instance =& Sd2nd_UpdateUtils::getProcess($this->_mParserPath,$arr['name']);
                if($instance instanceof Sd2nd_AbstractParser)
                {
                    $instance->reset($this->_mActiveId,$this,$line);
                    try
                    {
                        $instance->execute();
                    }
                    catch(Sd2nd_Exception $e)
                    {
                        Sd2nd_UpdateUtils::displayError($e);
                        if($e->isFatal())
                        {
                            throw $e;
                        }
                    }
                    unset($instance);
                }
            }
        }
    }
    
    /**
     * _save
     * 
     * @param   void
     * 
     * @return  void
     * @throw   Sd2nd_Exception
    **/
    abstract protected function _save();
}


?>
