<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_UpdateObject
**/
class Sd2nd_UpdateObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('update_time', XOBJ_DTYPE_INT, '', false);
    }
    
    /**
     * getFormatDate
     * 
     * @param   string  $format
     *              'Y' YYYY
     *              'y' yy
     *              'm' mm
     *              'd' dd
     * 
     * @param   string
    **/
    public function getFormatDate(/*** string ***/ $format = 'Y/m/d')
    {
        $updateTime = $this->get('update_time') + 20000000;
        $pat = array('Y','y','m','d');
        $rep = array(
            intval($updateTime / 10000),
            substr($updateTime,2,2),
            substr($updateTime,4,2),
            substr($updateTime,6,2)
        );
        
        return str_replace($pat,$rep,$format);
    }
}

/**
 * Sd2nd_UpdateHandler
**/
class Sd2nd_UpdateHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_update';
    public /*** string ***/ $mPrimary = 'update_time';
    public /*** string ***/ $mClass = 'Sd2nd_UpdateObject';
    protected /*** Sd2nd_UpdateObject[] ***/ $_mUpdateTimes = null;

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }

    /**
     * _setupUpdateTimes
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _setupUpdateTimes()
    {
        if($this->_mUpdateTimes != null)
        {
            return;
        }
        
        $cri = new Criteria(1,1);
        $cri->setSort($this->mPrimary,'desc');
        $this->_mUpdateTimes = $this->getObjects($cri);
    }

    /**
     * getLatestUpdate
     * 
     * @param   void
     * 
     * @return  Sd2nd_UpdateObject
    **/
    public function getLatestUpdate()
    {
        $this->_setupUpdateTimes();
        return isset($this->_mUpdateTimes[0]) ? $this->_mUpdateTimes[0] : null;
    }

    /**
     * getUpdateTimeList
     * 
     * @param   void
     * 
     * @return  Sd2nd_UpdateObject[]
    **/
    public function getUpdateTimeList()
    {
        $this->_setupUpdateTimes();
        return $this->_mUpdateTimes;
    }
}

?>
