<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_SkillElementLinkObject
**/
class Sd2nd_SkillElementLinkObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('skill_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('element', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_SkillElementLinkHandler
**/
class Sd2nd_SkillElementLinkHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_skill_element_link';

    /**
     * @brief   string
    **/
    public $mPrimary = 'skill_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_SkillElementLinkObject';

    /**
     * @brief   Enum{}
    **/
    protected $_mElements = array();

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
        
        $this->_mElements = array(
            -3 => _MD_SD2ND_LANG_ELEMENT_RANDOM,
            -2 => _MD_SD2ND_LANG_ELEMENT_UNDEFINED,
            -1 => _MD_SD2ND_LANG_ELEMENT_EMPTY
        );
        for($i = 0;$i <= 12;$i++)
        {
            $this->_mElements[$i] = constant('_MD_SD2ND_LANG_ELEMENT_' . $i);
        }
    }
    
    /**
     * setupSkillElement
     * 
     * @param   Sd2nd_SkillObject{} &$obs
     * 
     * @return  void
    **/
    public function setupSkillElement(/*** Sd2nd_SkillElementLinkObject{} ***/ &$objs)
    {
        if(count($objs) < 1)
        {
            return;
        }
        
        $cri = new CriteriaCompo();
        foreach(array_keys($objs) as $key)
        {
            $cri->add(new Criteria('skill_id',$key),'or');
        }
        
        foreach($this->getObjects($cri) as $obj)
        {
            $objs[$obj->get('skill_id')]->addElement($obj->get('element'));
        }
    }
    
    /**
     * convertToData
     * 
     * @param   string  $value
     * 
     * @return  int
    **/
    public function convertToData(/*** string ***/ $value)
    {
        return array_search($value,$this->_mElements);
    }
    
    /**
     * convertToView
     * 
     * @param   int $value
     * 
     * @return  string
    **/
    public function convertToView(/*** int ***/ $value)
    {
        return isset($this->_mElements[$value]) ? $this->_mElements[$value] : null;
    }
}

?>
