<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_MapNameObject
**/
class Sd2nd_MapNameObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('map_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('map_name', XOBJ_DTYPE_STRING, '', false, 50);
        $this->initVar('base_spot', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_MapNameHandler
**/
class Sd2nd_MapNameHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_map_name';
    public /*** string ***/ $mPrimary = 'map_id';
    public /*** string ***/ $mClass = 'Sd2nd_MapNameObject';
    protected /*** Sd2nd_MapNameObject{} ***/ $_mList = null;

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * _setupList
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _setupList()
    {
        $this->_mList =& $this->getObjects(null,null,null,true);
    }
    
    /**
     * getList
     * 
     * @param   void
     * 
     * @return  Sd2nd_MapNameObject{}
    **/
    public function getList()
    {
        $this->_setupList();
        return $this->_mList;
    }
    
    /**
     * convertToShow
     * 
     * @param   int $key
     * 
     * @return  string
    **/
    public function convertToShow(/*** int ***/ $key)
    {
        return $this->isValid($key) ? $this->_mList[$key] : null;
    }
    
    /**
     * isValid
     * 
     * @param   int $key
     * 
     * @return  bool
    **/
    public function isValid(/*** int ***/ $key)
    {
        $this->_setupList();
        return isset($this->_mList[$key]);
    }
}

?>
