<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_MapObject
**/
class Sd2nd_MapObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('map_id', XOBJ_DTYPE_INT, 1, false);
        $this->initVar('x', XOBJ_DTYPE_INT, '', false);
        $this->initVar('y', XOBJ_DTYPE_INT, '', false);
        $this->initVar('spot_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('update_time', XOBJ_DTYPE_INT, '', false);
    }
}


/**
 * @class   Sd2nd_MapCollection
**/
class Sd2nd_MapCollection implements Iterator
{
    const /*** Enum ***/ UNKNOWN_ID = 1;
    const /*** Enum ***/ IGNORE_UDON_ID = 6;
    const /*** Enum ***/ IGNORE_MOUNTAIN = 12;
    const /*** Enum ***/ IGNORE_DUNGEON_ID = 19;
    protected /*** int ***/ $_mMapId = null;
    protected /*** int{} ***/ $_mRange = array('minX' => 0,'maxX' => 0,'minY' => 0,'maxY' => 0);
    protected /*** Enum{}{} ***/ $_mMap = array();
    protected /*** Sd2nd_MapCacheHandler ***/ $_mCacheHandler = null;
    protected /*** Sd2nd_MapSpotObject{} ***/ $_mSpot = null;
    protected /*** int ***/ $_mUpdateTime = null;
    protected /*** int{} ***/ $_mCurrent = array('x' => null,'y' => null);
    protected /*** bool ***/ $_mIsLast = false;
    
    /**
     * __construct
     * 
     * @param   string  $dirname
     * @param   int     $updateTime
     * @param   int     $mapId
     * 
     * @return  void
    **/
    public function __construct(/*** string ***/ $dirname,/*** int ***/ $updateTime,/*** int ***/ $mapId = 1)
    {
        $asset =& Sd2nd_AssetManager::getInstance($dirname);
        $this->_mMapId = $mapId;
        $this->_mUpdateTime = $updateTime;
        $this->_mCacheHandler =& $asset->getObject('handler',Sd2nd_AssetManager::HANDLER_MAP_CACHE);
        $spotHandler =& $asset->getObject('handler',Sd2nd_AssetManager::HANDLER_MAP_SPOT);
        $this->_mSpot =& $spotHandler->getObjects(null,null,null,true);
    }
    
    /**
     * add
     * 
     * @param   Sd2nd_MapObject $obj
     * 
     * @return  void
    **/
    public function add(Sd2nd_MapObject $obj)
    {
        $this->_add($obj->get('x'),$obj->get('y'),$obj->get('spot_id'));
    }
    
    /**
     * addBySpotList
     * 
     * @param   int     $baseX
     * @param   int     $baseY
     * @param   int[][] $spotList
     * 
     * @return  
    **/
    public function addBySpotList(/*** int ***/ $baseX,/*** int ***/ $baseY,/*** int[][] ***/ $spotList)
    {
        foreach($spotList as $relativeY => $line)
        {
            foreach($line as $relativeX => $spot)
            {
                $x = $baseX + $relativeX;
                $y = $baseY + $relativeY;
                if($spot != self::UNKNOWN_ID && (!isset($this->_mMap[$x][$y]) || !in_array($spot,array($this->_mMap[$x][$y],self::IGNORE_UDON_ID,self::IGNORE_MOUNTAIN,self::IGNORE_DUNGEON_ID))))
                {
                    $this->_add($x,$y,$spot);
                    $map =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_MAP);
                    $map->setVars(array('map_id' => $this->_mMapId,'x' => $x,'y' => $y,'spot_id' => $spot,'update_time' => $this->_mUpdateTime));
                    Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_MAP,$map);
                }
            }
        }
    }
    
    /**
     * load
     * 
     * @param   int $updateTime
     * @param   int $mapId
     * 
     * @return  bool
    **/
    public function load(/*** int ***/ $updateTime,/*** int ***/ $mapId)
    {
        if($cache =& $this->_mCacheHandler->getByUnique($mapId,$updateTime))
        {
            $this->_mMapId = $mapId;
            $this->_mRange = unserialize($cache->get('map_range'));
            $this->_mMap = unserialize($cache->get('map_body'));
            return true;
        }
        
        return false;
    }
    
    /**
     * _add
     * 
     * @param   int     $x
     * @param   int     $y
     * @param   Enum    $spot
     * 
     * @return  void
    **/
    protected function _add(/*** int ***/ $x,/*** int ***/ $y,/*** Enum ***/ $spot)
    {
        if($x < $this->_mRange['minX'])
        {
            $this->_mRange['minX'] = $x;
        }
        if($x > $this->_mRange['maxX'])
        {
            $this->_mRange['maxX'] = $x;
        }
        if($y < $this->_mRange['minY'])
        {
            $this->_mRange['minY'] = $y;
        }
        if($y > $this->_mRange['maxY'])
        {
            $this->_mRange['maxY'] = $y;
        }
        
        $this->_mMap[$x][$y] = $spot;
    }
    
    /**
     * save
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function save()
    {
        $cache =& Sd2nd_UpdateUtils::createObject(Sd2nd_AssetManager::HANDLER_MAP_CACHE);
        $cache->setVars(array('map_id' => $this->_mMapId,'update_time' => $this->_mUpdateTime,'map_range' => serialize($this->_mRange),'map_body' => serialize($this->_mMap)));
        Sd2nd_UpdateUtils::insertObject(Sd2nd_AssetManager::HANDLER_MAP_CACHE,$cache);
    }
    
    /**
     * get
     * 
     * @param   int     $x
     * @param   int     $y
     * 
     * @return  Sd2nd_MapSpotObject
    **/
    public function get(/*** int ***/ $x,/*** int ***/ $y)
    {
        $id = isset($this->_mMap[$x][$y]) ? $this->_mMap[$x][$y] : self::UNKNOWN_ID;
        return isset($this->_mSpot[$id]) ? $this->_mSpot[$id] : $this->_mSpot[self::UNKNOWN_ID];
    }
    
    /**
     * current
     * 
     * @param   void
     * 
     * @return  Sd2nd_MapSpotObject
    **/
    public function current()
    {
        return $this->get($this->_mCurrent['x'],$this->_mCurrent['y']);
    }
    
    /**
     * key
     * 
     * @param   void
     * 
     * @return  int{}
    **/
    public function key()
    {
        return $this->_mCurrent;
    }
    
    /**
     * next
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function next()
    {
        $this->_mCurrent['x']++;
        if($this->_mCurrent['x'] > $this->_mRange['maxX'])
        {
            $this->_mCurrent['x'] = $this->_mRange['minX'];
            $this->_mCurrent['y']++;
            if($this->_mCurrent['y'] > $this->_mRange['maxY'])
            {
                $this->_mIsLast = true;
                $this->_mCurrent['y'] = $this->_mRange['maxY'];
            }
        }
    }
    
    /**
     * rewind
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function rewind()
    {
        $this->_mCurrent = array('x' => $this->_mRange['minX'],'y' => $this->_mRange['minY']);
        $this->_mIsLast = false;
    }
    
    /**
     * seek
     * 
     * @param   int{}   $key
     * 
     * @return  void
    **/
    public function seek(/*** int{} ***/ $key)
    {
        if(!isset($key['x']) || !isset($key['y']))
        {
            return;
        }
        
        $x = $key['x'];
        $y = $key['y'];
        if($x < $this->_mRange['minX'] || $x > $this->_mRange['maxX'] || $y < $this->_mRange['minY'] ||  $y > $this->_mMapSize['maxY'])
        {
            return;
        }
        
        $this->_mCurrent = array('x' => $x,'y' => $y);
        $this->_mIsLast = ($this->isMaxX() && $this->isMaxY());
    }
    
    /**
     * valid
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function valid()
    {
        return !$this->_mIsLast;
    }
    
    /**
     * isMaxX
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function isMaxX()
    {
        return $this->_mCurrent['x'] == $this->_mRange['maxX'];
    }
    
    /**
     * isMaxY
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public function isMaxY()
    {
        return $this->_mCurrent['y'] == $this->_mRange['maxY'];
    }
    
    /**
     * getDistance
     * 
     * @param   void
     * 
     * @return  int
    **/
    public function getDistance()
    {
        return abs($this->_mCurrent['x']) + abs($this->_mCurrent['y']);
    }
}


/**
 * Sd2nd_MapHandler
**/
class Sd2nd_MapHandler extends XoopsObjectGenericHandler
{
    public /*** string ***/ $mTable = '{dirname}_map';
    public /*** string ***/ $mPrimary = 'x';
    public /*** string ***/ $mClass = 'Sd2nd_MapObject';
    protected /*** string ***/ $_mDirname = null;

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->_mDirname = $dirname;
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * getCollection
     * 
     * @param   int $baseTime
     * @param   int $loadTime
     * @param   int $mapId
     * 
     * @return  Sd2nd_MapCollection
    **/
    public function getCollection(/*** int ***/ $baseTime,/*** int ***/ $loadTime = null,/*** int ***/ $mapId = 1)
    {
        $collection = new Sd2nd_MapCollection($this->_mDirname,$baseTime,$mapId);
        $collection->load($loadTime == null ? $baseTime : $loadTime,$mapId);
        return $collection;
    }
}


?>
