<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_LearnedSkillObject
**/
class Sd2nd_LearnedSkillObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('skill_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('regist_time', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_LearnedSkillHandler
**/
class Sd2nd_LearnedSkillHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_learned_skill';

    /**
     * @brief   string
    **/
    public $mPrimary = 'eno';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_LearnedSkillObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
