<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_KindObject
**/
class Sd2nd_KindObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('kind_id', XOBJ_DTYPE_INT, '', false);
        $this->initVar('kind_name', XOBJ_DTYPE_STRING, '', false, 20);
        $this->initVar('kind_kind', XOBJ_DTYPE_INT, '', false);
        $this->initVar('weight', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_KindHandler
**/
class Sd2nd_KindHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_kind';

    /**
     * @brief   string
    **/
    public $mPrimary = 'kind_id';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_KindObject';

    /**
     * @brief   Sd2nd_KindObject{}
    **/
    protected $_mConvertTable = null;

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
    
    /**
     * _setupConvertTable
     * 
     * @param   void
     * 
     * @return  void
    **/
    protected function _setupConvertTable()
    {
        if($this->_mConvertTable == null)
        {
            $cri = new CriteriaCompo();
            $cri->setSort('weight','ASC');
            $cri->addSort('kind_name','ASC');
            $this->_mConvertTable =& $this->getObjects($cri,null,null,true);
        }
    }
    
    /**
     * getList
     * 
     * @param   void
     * 
     * @return  Sd2nd_KindObject{}
    **/
    public function getList()
    {
        $this->_setupConvertTable();
        return $this->_mConvertTable;
    }
    
    /**
     * convertToView
     * 
     * @param   int $key
     * 
     * @return  string
    **/
    public function convertToView(/*** int ***/ $key)
    {
        $this->_setupConvertTable();
        return isset($this->_mConvertTable[$key]) ? $this->_mConvertTable[$key]->getShow('kind_name') : null;
    }
}

?>
