<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

/**
 * Sd2nd_ActiveAbilityObject
**/
class Sd2nd_ActiveAbilityObject extends XoopsSimpleObject
{
    /**
     * __construct
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function __construct()
    {
        $this->initVar('eno', XOBJ_DTYPE_INT, '', false);
        $this->initVar('slot', XOBJ_DTYPE_INT, '', false);
        $this->initVar('ability_id', XOBJ_DTYPE_INT, '', false);
    }
}

/**
 * Sd2nd_ActiveAbilityHandler
**/
class Sd2nd_ActiveAbilityHandler extends XoopsObjectGenericHandler
{
    /**
     * @brief   string
    **/
    public $mTable = '{dirname}_active_ability';

    /**
     * @brief   string
    **/
    public $mPrimary = 'eno';

    /**
     * @brief   string
    **/
    public $mClass = 'Sd2nd_ActiveAbilityObject';

    /**
     * __construct
     * 
     * @param   XoopsDatabase  &$db
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
    {
        $this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
        parent::XoopsObjectGenericHandler($db);
    }
}

?>
