<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Sd2nd_SkillListAction
**/
class Sd2nd_SkillListAction extends Sd2nd_AbstractUpdateListAction
{
    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  Sd2nd_SkillHandler
    **/
    protected function &_getHandler()
    {
        $handler =& $this->mAsset->getObject('handler', 'skill');
        return $handler;
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Sd2nd_SkillFilterForm
    **/
    protected function &_getFilterForm()
    {
        // $filter = new Sd2nd_SkillFilterForm();
        $filter =& $this->mAsset->getObject('filter', 'skill',false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
        return './index.php?action=SkillList';
    }

    /**
     * getDefaultView
     * 
     * @param   void
     * 
     * @return  Enum
    **/
    public function getDefaultView()
    {
        $this->mFilter =& $this->_getFilterForm();
        $this->mFilter->fetch();
    
        $handler =& $this->_getHandler();
        $this->mObjects =& $handler->getObjects($this->mFilter->getCriteria(),null,null,true);
    
        return SD2ND_FRAME_VIEW_INDEX;
    }

    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_skill_list.html');
        #cubson::lazy_load_array('skill', $this->mObjects);
        $handler =& $this->mAsset->getObject('handler','SkillElementLink');
        $handler->setupSkillElement($this->mObjects);
        
        $render->setAttribute('objects', $this->mObjects);
        $render->setAttribute('pageNavi', $this->mFilter->mNavi);
        $render->setAttribute('updateHandler',$this->_mUpdateHandler);
        $render->setAttribute('targetHandler',$this->mAsset->getObject('handler','target'));
        $render->setAttribute('kindHandler',$this->mAsset->getObject('handler','kind'));
        $render->setAttribute('elementLinkHandler',$handler);
    }
}

?>
