<?php
/**
 * @file
 * @package sd2nd
 * @version $Id$
**/

if(!defined('XOOPS_ROOT_PATH'))
{
    exit;
}

require_once SD2ND_TRUST_PATH . '/class/AbstractListAction.class.php';

/**
 * Sd2nd_AbilityListAction
**/
class Sd2nd_AbilityListAction extends Sd2nd_AbstractUpdateListAction
{
    /**
     * &_getHandler
     * 
     * @param   void
     * 
     * @return  Sd2nd_AbilityHandler
    **/
    protected function &_getHandler()
    {
        $handler =& $this->mAsset->getObject('handler', 'ability');
        return $handler;
    }

    /**
     * &_getFilterForm
     * 
     * @param   void
     * 
     * @return  Sd2nd_AbilityFilterForm
    **/
    protected function &_getFilterForm()
    {
        // $filter = new Sd2nd_AbilityFilterForm();
        $filter =& $this->mAsset->getObject('filter', 'ability',false);
        $filter->prepare($this->_getPageNavi(), $this->_getHandler());
        return $filter;
    }

    /**
     * _getBaseUrl
     * 
     * @param   void
     * 
     * @return  string
    **/
    protected function _getBaseUrl()
    {
        return './index.php?action=AbilityList';
    }

    /**
     * executeViewIndex
     * 
     * @param   XCube_RenderTarget  &$render
     * 
     * @return  void
    **/
    public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
    {
        $render->setTemplateName($this->mAsset->mDirname . '_ability_list.html');
        #cubson::lazy_load_array('ability', $this->mObjects);
        $render->setAttribute('objects', $this->mObjects);
        $render->setAttribute('pageNavi', $this->mFilter->mNavi);
        $render->setAttribute('updateHandler',$this->_mUpdateHandler);
    }
}

?>
