<?php
/**
 * @package user
 * @version $Id: UserSearchFilterForm.class.php,v 1.3 2007/09/08 01:09:39 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserSearchForm.class.php";

define('USER_SORT_KEY_UID', 1);
define('USER_SORT_KEY_NAME', 2);
define('USER_SORT_KEY_UNAME', 3);
define('USER_SORT_KEY_EMAIL', 4);
define('USER_SORT_KEY_USER_REGDATE', 7);
define('USER_SORT_KEY_USER_VIEWEMAIL', 11);
define('USER_SORT_KEY_ACTKEY', 12);
define('USER_SORT_KEY_PASS', 16);
define('USER_SORT_KEY_LEVEL', 20);
define('USER_SORT_KEY_TIMEZONE_OFFSET', 22);
define('USER_SORT_KEY_LAST_LOGIN', 23);
define('USER_SORT_KEY_USER_MAILOK', 31);

define('USER_SORT_KEY_DEFAULT', USER_SORT_KEY_UID);

class User_UserSearchFilterForm extends User_AbstractFilterForm
{
	var $mSortKeys = array(
		USER_SORT_KEY_UID => 'u.uid',
		USER_SORT_KEY_NAME => 'u.name',
		USER_SORT_KEY_UNAME => 'u.uname',
		USER_SORT_KEY_EMAIL => 'u.email',
		USER_SORT_KEY_USER_REGDATE => 'u.user_regdate',
		USER_SORT_KEY_USER_VIEWEMAIL => 'u.user_viewemail',
		USER_SORT_KEY_ACTKEY => 'u.actkey',
		USER_SORT_KEY_PASS => 'u.pass',
		USER_SORT_KEY_LEVEL => 'u.level',
		USER_SORT_KEY_TIMEZONE_OFFSET => 'u.timezone_offset',
		USER_SORT_KEY_LAST_LOGIN => 'u.last_login',
	);

	var $_mMatchFields = array ("uname", "name", "email");
	
	function getDefaultSortKey()	
	{
		return USER_SORT_KEY_DEFAULT;
	}
								
	function fetch()
	{
		parent::fetch();

		$form =& new User_UserSearchForm();
		$form->prepare();

		$form->fetch();
		$form->validate();
		
		if ($form->hasError()) {
			return;
		}
		
		foreach ($this->_mMatchFields as $field) {
			if (strlen($form->get($field)) > 0) {
				$this->mNavi->addExtra($field, $form->get($field));
				$this->_mCriteria->add(new Criteria('u.' . $field, '%' . $form->get($field) . '%', 'LIKE'));
			}
		}
		
		$this->mNavi->addExtra('mail_condition', $form->get('mail_condition'));
		switch ($form->get('mail_condition')) {
			case 1:
				$this->_mCriteria->add(new Criteria('u.user_mailok', 1));
				break;
				
			case 2:
				$this->_mCriteria->add(new Criteria('u.user_mailok', 0));
				break;
		}

		$this->mNavi->addExtra('user_level', $form->get('user_level'));
		switch ($form->get('user_level')) {
			case 1:
				$this->_mCriteria->add(new Criteria('u.level', 0, '>'));
				break;
				
			case 2:
				$this->_mCriteria->add(new Criteria('u.level', 0));
				break;
		}
		
		if (strlen($form->get('lastlog_more')) > 0) {
			$this->mNavi->addExtra('lastlog_more', $form->get('lastlog_more'));
			$time = time() - $form->get('lastlog_more') * 86400;
			$this->_mCriteria->add(new Criteria('u.last_login', $time, '<='));
		}

		if (strlen($form->get('lastlog_less')) > 0) {
			$this->mNavi->addExtra('lastlog_less', $form->get('lastlog_less'));
			$time = time() - $form->get('lastlog_less') * 86400;
			$this->_mCriteria->add(new Criteria('u.last_login', $time, '>='));
		}

		if (strlen($form->get('regdate_more')) > 0) {
			$this->mNavi->addExtra('regdate_more', $form->get('regdate_more'));
			$time = time() - $form->get('regdate_more') * 86400;
			$this->_mCriteria->add(new Criteria('u.user_regdate', $time, '<='));
		}

		if (strlen($form->get('regdate_less')) > 0) {
			$this->mNavi->addExtra('regdate_less', $form->get('regdate_less'));
			$time = time() - $form->get('regdate_less') * 86400;
			$this->_mCriteria->add(new Criteria('u.user_regdate', $time, '>='));
		}
		
		$groups = $form->get('groups');
		if (count($groups) > 0) {
			$g_criteria =& new CriteriaCompo();
			foreach($groups as $gid) {
				$g_criteria->add(new Criteria('g.groupid', $gid), 'OR');
				$this->mNavi->addExtra('groups[' . $gid . ']', $gid);
			}
			$this->_mCriteria->add($g_criteria);
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
