<?php
/**
 * @package user
 * @version $Id: UserFilterForm.class.php,v 1.2 2007/06/07 05:27:37 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";

define('USER_SORT_KEY_UID', 1);
define('USER_SORT_KEY_NAME', 2);
define('USER_SORT_KEY_UNAME', 3);
define('USER_SORT_KEY_EMAIL', 4);
define('USER_SORT_KEY_USER_REGDATE', 7);
define('USER_SORT_KEY_USER_VIEWEMAIL', 11);
define('USER_SORT_KEY_ACTKEY', 12);
define('USER_SORT_KEY_PASS', 16);
define('USER_SORT_KEY_LEVEL', 20);
define('USER_SORT_KEY_TIMEZONE_OFFSET', 22);
define('USER_SORT_KEY_LAST_LOGIN', 23);
define('USER_SORT_KEY_USER_MAILOK', 31);

define('USER_SORT_KEY_DEFAULT', USER_SORT_KEY_UID);

/***
 * @internal
 * [Notice]
 * We should have our policy about filtering items.
 */
class User_UserFilterForm extends User_AbstractFilterForm
{
	var $mSortKeys = array(
		USER_SORT_KEY_UID => 'uid',
		USER_SORT_KEY_NAME => 'name',
		USER_SORT_KEY_UNAME => 'uname',
		USER_SORT_KEY_EMAIL => 'email',
		USER_SORT_KEY_USER_REGDATE => 'user_regdate',
		USER_SORT_KEY_USER_VIEWEMAIL => 'user_viewemail',
		USER_SORT_KEY_ACTKEY => 'actkey',
		USER_SORT_KEY_PASS => 'pass',
		USER_SORT_KEY_LEVEL => 'level',
		USER_SORT_KEY_TIMEZONE_OFFSET => 'timezone_offset',
		USER_SORT_KEY_LAST_LOGIN => 'last_login',
		USER_SORT_KEY_USER_MAILOK => 'user_mailok'
	);

	function getDefaultSortKey()
	{
		return USER_SORT_KEY_DEFAULT;
	}
	
	function fetch()
	{
		parent::fetch();
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
	
		if (($value = $request->getRequest('uid')) !== null) {
			$this->mNavi->addExtra('uid', $value);
			$this->_mCriteria->add(new Criteria('uid', $value));
		}

		if (($value = $request->getRequest('email')) !== null) {
			$this->mNavi->addExtra('email', $value);
			$this->_mCriteria->add(new Criteria('email', $value));
		}
	
		if (($value = $request->getRequest('level')) !== null) {
			$this->mNavi->addExtra('level', $value);
			$this->_mCriteria->add(new Criteria('level', $value));
		}
	
		if (($value = $request->getRequest('timezone_offset')) !== null) {
			$this->mNavi->addExtra('timezone_offset', $value);
			$this->_mCriteria->add(new Criteria('timezone_offset', $value));
		}
	
		if (($value = $request->getRequest('user_mailok')) !== null) {
			$this->mNavi->addExtra('user_mailok', $value);
			$this->_mCriteria->add(new Criteria('user_mailok', $value));
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
