<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacyRender/admin/forms/TplfileFilterForm.class.php";

/***
 * @internal
 * This class is a filter form for list up tplfile object *with* override.
 */
class LegacyRender_TplfileSetFilterForm extends LegacyRender_TplfileFilterForm
{
	function additionalFetch()
	{
        $request =& XCube_Root::getSingleton()->mContext->mRequest;
		if (($value = $request->getRequest('tpl_module')) !== null) {
			$this->mNavi->addExtra('tpl_module', $value);
			$this->_mCriteria->add(new Criteria('tpl_module', array(XOBJ_DTYPE_STRING, $value)));
			
			$handler =& xoops_gethandler('module');
			$this->mModule =& $handler->getByDirname($value);
		}
	
		if (($value = $request->getRequest('tpl_tplset')) !== null) {
			$this->mNavi->addExtra('tpl_tplset', $value);
			
			//
			// For the procedure of override, must load 'default' template-set here.
			// The template of the specified template-set will be loaded in Tplset Object.
			// See business-logic.
			//
			$subCriteria = new CriteriaCompo();
			$subCriteria->add(new Criteria('tpl_tplset', 'default'), 'OR');
			
			$handler =& xoops_getmodulehandler('tplset');
			$tplsets =& $handler->getObjects(new Criteria('tplset_name', $value));
			if (count($tplsets) > 0) {
				$subCriteria->add(new Criteria('tpl_tplset', $value));
				$this->mTplset =& $tplsets[0];
			}
            $this->_mCriteria->add($subCriteria);
		}
	
		if (($value = $request->getRequest('tpl_type')) !== null) {
			$this->mNavi->addExtra('tpl_type', $value);
			$this->_mCriteria->add(new Criteria('tpl_type', array(XOBJ_DTYPE_STRING, $value)));
		}
		
		if (($value = $request->getRequest('tpl_file')) !== null) {
			$this->mNavi->addExtra('tpl_file', $value);
			$this->_mCriteria->add(new Criteria('tpl_file', '%' . $value . '%', 'LIKE'));
		}

		//
		// check filtering criterion and if module & tplset specified mode, then remove paging function.
		//
		if ($this->mModule != null && $this->mTplset != null) {
			$this->mNavi->setPerpage(0);
			$this->mNavi->freezePerpage();
		}
		
		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());
	}
}

?>
