package PluginManager::Repository;

use strict;
use warnings;

sub repository_root {
	my ($create_if_not_exists) = @_;

	my $app = MT->instance;
    my $dir_mode = (~ oct(MT->config('DirUmask'))) & oct('777');
	#File::Spec->catdir($app->server_path(), 'mpm');
	my $path = File::Spec->catdir($app->support_directory_path, 'mpm');
	if (! -d $path && $create_if_not_exists) {
		mkdir($path);
		chmod($dir_mode, $path);
	}
	$path;
}

sub repository_pool {
	my ($create_if_not_exists) = @_;

    my $dir_mode = (~ oct(MT->config('DirUmask'))) & oct('777');
	my $path = File::Spec->catdir(repository_root(@_), 'pool');
	if (! -d $path && $create_if_not_exists) {
		mkdir($path);
		chmod($dir_mode, $path);
	}
	$path;
}

sub repository_url {
	my ($create_if_not_exists) = @_;

	my $app = MT->instance;
	my $root_path = repository_root;
	
	return '' if ! -d $root_path;

	return $app->support_directory_url . 'mpm/';
}

sub available_components {
	my @defaults = qw(
		core
		typepadantispam
		markdown/smartypants.pl
		spamlookup/spamlookup_words.pl
		spamlookup/spamlookup.pl
		multiblog
		textile/textile2.pl
		spamlookup/spamlookup_urls.pl
		wxrimporter/wxrimporter.pl
		stylecatcher
		markdown/markdown.pl
		cloner/cloner.pl
		facebookcommenters
		community
		actionstreams
		commercial
		widgetmanager
		motion
		mixicomment
		feedsapplite
		communityactionstreams
		
		pluginmanager
	);
	my $defaults_count = scalar(@defaults);
	my %comp = %MT::Components;
	grep({
		my $c = $_;
		grep({ $_ ne $c } @defaults) == $defaults_count
	} keys(%MT::Components));
}

1;
