/******************************************************************************/
/*                                                                            */
/* src/lib/libc/string/strcpy.c                                               */
/*                                                                 2019/04/02 */
/* Copyright (C) 2016-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
/******************************************************************************/
/* グローバル関数宣言                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       strcpy
 * @details     文字列をnull文字までコピーする。
 *
 * @param[in]   *s1 コピー先文字列
 * @param[in]   *s2 コピー元文字列
 *
 * @return      コピー先文字列
 *
 * @note        null文字もコピーされる。
 */
/******************************************************************************/
char *strcpy( char       *s1,
              const char *s2  )
{
    char *pRet;

    /* 初期化 */
    pRet = s1;

    /* null文字まで繰り返し */
    while ( *s2 != '\0' ) {
        /* コピー */
        *s1 = *s2;

        /* アドレス更新 */
        s1++;
        s2++;
    }

    /* null文字コピー */
    *s1 = *s2;

    return pRet;
}


/******************************************************************************/
