/******************************************************************************/
/*                                                                            */
/* src/kernel/TaskMng/TaskMng.c                                               */
/*                                                                 2019/08/09 */
/* Copyright (C) 2017-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stdarg.h>
#include <stdint.h>

/* 外部モジュールヘッダ */
#include <Cmn.h>
#include <Debug.h>

/* 内部モジュールヘッダ */
#include "TaskMngName.h"
#include "TaskMngProc.h"
#include "TaskMngSched.h"
#include "TaskMngTask.h"
#include "TaskMngTbl.h"
#include "TaskMngThread.h"
#include "TaskMngTss.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/** デバッグトレースログ出力マクロ */
#ifdef DEBUG_LOG_ENABLE
#define DEBUG_LOG( ... )                        \
    DebugLogOutput( CMN_MODULE_TASKMNG_MAIN,    \
                    __LINE__,                   \
                    __VA_ARGS__              )
#else
#define DEBUG_LOG( ... )
#endif


/******************************************************************************/
/* グローバル関数定義                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       タスク管理初期化
 * @details     タスク管理内サブモジュールの初期化を行う。
 */
/******************************************************************************/
void TaskMngInit( void )
{
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "%s() start.", __func__ );

    /* テーブル管理初期化 */
    TblInit();

    /* プロセス制御初期化 */
    ProcInit();

    /* スレッド制御初期化 */
    ThreadInit();

    /* タスク制御初期化 */
    TaskInit();

    /* TSS管理初期化 */
    TssInit();

    /* タスク名管理初期化 */
    NameInit();

    /* スケジューラ初期化 */
    SchedInit();

    /* デバッグトレースログ出力 */
    DEBUG_LOG( "%s() end.", __func__ );

    return;
}


/******************************************************************************/
