/******************************************************************************/
/*                                                                            */
/* src/kernel/include/hardware/I8254/I8254.h                                  */
/*                                                                 2019/07/23 */
/* Copyright (C) 2016-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef I8254_H
#define I8254_H
/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* PITポート定義 */
#define I8254_PORT_CNTR0     ( 0x40 )   /**< PITカウンタ0レジスタ          */
#define I8254_PORT_CNTR1     ( 0x41 )   /**< PITカウンタ1レジスタ          */
#define I8254_PORT_CNTR2     ( 0x42 )   /**< PITカウンタ2レジスタ          */
#define I8254_PORT_CTRLW     ( 0x43 )   /**< PITコントロールワードレジスタ */

/* コントロールワードレジスタビット定義 */
#define I8254_CTRLW_SC_CNTR0 ( 0x00 )   /**< 制御カウンタ：カウンタ0        */
#define I8254_CTRLW_SC_CNTR1 ( 0x40 )   /**< 制御カウンタ：カウンタ1        */
#define I8254_CTRLW_SC_CNTR2 ( 0x80 )   /**< 制御カウンタ：カウンタ2        */
#define I8254_CTRLW_RW_LSB   ( 0x10 )   /**< 書込み方法：最下位バイトのみ   */
#define I8254_CTRLW_RW_MSB   ( 0x20 )   /**< 書込み方法：最上位バイトのみ   */
#define I8254_CTRLW_RW_BOTH  ( 0x30 )   /**< 書込み方法：2回に分けて両方    */
#define I8254_CTRLW_M_MODE0  ( 0x00 )   /**< モード：カウンタ0で割込み      */
#define I8254_CTRLW_M_MODE1  ( 0x02 )   /**< モード：ワンショット           */
#define I8254_CTRLW_M_MODE2  ( 0x04 )   /**< モード：レートジェネレータ     */
#define I8254_CTRLW_M_MODE3  ( 0x06 )   /**< モード：方形波                 */
#define I8254_CTRLW_M_MODE4  ( 0x08 )   /**< モード：ソフトトリガストローブ */
#define I8254_CTRLW_M_MODE5  ( 0x0A )   /**< モード：ハードトリガストローブ */
#define I8254_CTRLW_BCD_BIN  ( 0x00 )   /**< カウント方法：バイナリ         */
#define I8254_CTRLW_BCD_BCD  ( 0x01 )   /**< カウント方法：BCD              */

/** クロック数(Hz) */
#define I8254_CLOCK          ( 1193182 )

/** カウンタ（最下位バイト）マクロ */
#define I8254_CNTR_LOW( _CNT ) \
    ( ( uint8_t ) (   ( ( uint16_t ) ( _CNT ) ) & 0x00FF )        )
/** カウンタ（最上位バイト）マクロ */
#define I8254_CNTR_HIGH( _CNT ) \
    ( ( uint8_t ) ( ( ( ( uint16_t ) ( _CNT ) ) & 0xFF00 ) >> 8 ) )


/******************************************************************************/
#endif
