/******************************************************************************/
/*                                                                            */
/* src/booter/include/Driver.h                                                */
/*                                                                 2019/07/24 */
/* Copyright (C) 2017-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef DRIVER_H
#define DRIVER_H
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stddef.h>
#include <stdint.h>

/* 外部モジュールヘッダ */
#include <Cmn.h>


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/*----------*
 * Driver.c *
 *----------*/
/* ドライバ初期化 */
extern void DriverInit( void );


/*-------------*
 * DriverA20.c *
 *-------------*/
/* A20ライン有効化 */
extern CmnRet_t DriverA20Enable( void );


/*-------------*
 * DriverAta.c *
 *-------------*/
/* ATA割込みハンドラ */
extern void DriverAtaHandler( uint32_t intNo );

/* ディスク読み込み */
extern CmnRet_t DriverAtaRead( void     *pAddr,
                               uint32_t lba,
                               size_t   size    );


/******************************************************************************/
#endif
