/******************************************************************************/
/*                                                                            */
/* kernel/task.h                                                              */
/*                                                                 2019/08/28 */
/* Copyright (C) 2019 Mochi.                                                  */
/*                                                                            */
/******************************************************************************/
#ifndef __KERNEL_TASK_H__
#define __KERNEL_TASK_H__
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stdint.h>

/* カーネルヘッダ */
#include <kernel/types.h>


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/** タスク管理割込み番号 */
#define MK_TASK_INTNO MK_CONFIG_INTNO_TASK

/* 機能ID */
#define MK_TASK_FUNCID_GET_ID ( 0x00000001 )    /**< タスクID取得 */

/** タスク管理パラメータ */
typedef struct {
    uint32_t   funcId;  /**< 機能ID     */
    MkRet_t    ret;     /**< 戻り値     */
    MkErr_t    err;     /**< エラー内容 */
    MkTaskId_t taskId;  /**< タスクID   */
} MkTaskParam_t;


/******************************************************************************/
#endif

