/******************************************************************************/
/*                                                                            */
/* kernel/iomem.h                                                             */
/*                                                                 2019/07/27 */
/* Copyright (C) 2018-2019 Mochi.                                             */
/*                                                                            */
/******************************************************************************/
#ifndef __KERNEL_IOMEM_H__
#define __KERNEL_IOMEM_H__
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 標準ヘッダ */
#include <stddef.h>
#include <stdint.h>

/* カーネルヘッダ */
#include "config.h"
#include "types.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/** I/Oメモリ制御割込み番号 */
#define MK_IOMEM_INTNO MK_CONFIG_INTNO_IOMEM

/* 機能ID */
#define MK_IOMEM_FUNCID_ALLOC     ( 0x00000001 )    /**< I/Oメモリ領域割当 */

/** I/Oメモリ制御機能パラメータ */
typedef struct {
    uint32_t funcId;        /**< 機能ID                    */
    MkRet_t  ret;           /**< 戻り値                    */
    MkErr_t  err;           /**< エラー内容                */
    void     *pIoAddr;      /**< I/Oメモリ領域先頭アドレス */
    size_t   size;          /**< I/Oメモリ領域サイズ       */
    void     *pVirtAddr;    /**< 割当先メモリアドレス      */
} MkIoMemParam_t;


/******************************************************************************/
#endif
