/******************************************************************************/
/* src/kernel/ProcMng/ProcMngInit.c                                           */
/*                                                                 2017/03/11 */
/* Copyright (C) 2017 Mochi.                                                  */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 共通ヘッダ */
#include <stdarg.h>
#include <stdint.h>

/* 外部モジュールヘッダ */
#include <Cmn.h>
#include <Debug.h>

/* 内部モジュールヘッダ */
#include "ProcMngSched.h"
#include "ProcMngTask.h"
#include "ProcMngTss.h"


/******************************************************************************/
/* 定義                                                                       */
/******************************************************************************/
/* デバッグトレースログ出力マクロ */
#ifdef DEBUG_LOG_ENABLE
#define DEBUG_LOG( ... )                        \
    DebugLogOutput( CMN_MODULE_PROCMNG_INIT,    \
                    __LINE__,                   \
                    __VA_ARGS__ )
#else
#define DEBUG_LOG( ... )
#endif


/******************************************************************************/
/* グローバル関数定義                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       プロセス管理初期化
 * @details     プロセス管理内サブモジュールの初期化を行う。
 */
/******************************************************************************/
void ProcMngInit( void )
{
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "%s() start.", __func__ );
    
    /* TSS管理サブモジュール初期化 */
    ProcMngTssInit();
    
    /* タスク管理サブモジュール初期化 */
    ProcMngTaskInit();
    
    /* スケジューラサブモジュール初期化 */
    ProcMngSchedInit();
    
    /* デバッグトレースログ出力 */
    DEBUG_LOG( "%s() end.", __func__ );
    
    return;
}


/******************************************************************************/
