/******************************************************************************/
/* src/booter/Loader/LoaderLoad.s                                             */
/*                                                                 2016/12/04 */
/* Copyright (C) 2016 Mochi.                                                  */
/******************************************************************************/
.intel_syntax noprefix
.code16
/******************************************************************************/
/* グローバル宣言                                                             */
/******************************************************************************/
.global LoaderLoadKernel


/******************************************************************************/
/* TEXTセクション                                                             */
/******************************************************************************/
.section .text
LoaderLoadKernel:
    /* カーネル格納位置取得 */
    xor         ax, ax
    mov         ds, ax
    mov         eax, [ 0x7A00 + 0x1CE + 0x8 ]
    mov         [ pReadAddr ], eax
    
    /* メインプログラム読み込み */
    mov         ah, 0x42                    /* 機能番号（EXTENDED READ）   */
    mov         dl, 0x80                    /* ドライブ番号                */
    mov         si, offset pDiskAddrPckt    /* Disk address packetアドレス */
    int         0x13
    
    ret
    

/******************************************************************************/
/* DATAセクション                                                             */
/******************************************************************************/
.section .data
.align 8
/* Disk address packet */
pDiskAddrPckt:
    .byte       0x10            /* サイズ                          */
    .byte       0x00            /* Reserved                        */
    .word       0x0070          /* 読込み論理セクタ数              */
    .word       0x0010          /* 転送先アドレス（オフセット）    */
    .word       0xFFFF          /* 転送先アドレス（セグメント）    */
pReadAddr:
    .long       0x00000000      /* 読込み先頭論理セクタ番号（LSB） */
    .long       0x00000000      /* 読込み先頭論理セクタ番号（MSB） */


/******************************************************************************/
