/******************************************************************************/
/* src/kernel/Test.c                                                          */
/*                                                                 2017/03/21 */
/* Copyright (C) 2017 Mochi.                                                  */
/******************************************************************************/
/******************************************************************************/
/* インクルード                                                               */
/******************************************************************************/
/* 共通ヘッダ */
#include <stdint.h>

/* 外部モジュールヘッダ */

/* 内部モジュールヘッダ */


/******************************************************************************/
/* 変数定義                                                                   */
/******************************************************************************/
/* タスクＡ用カウンタ */
static uint32_t gTestCounterA = 0;
static uint32_t gTestCounterB = 0;


/******************************************************************************/
/* グローバル関数定義                                                         */
/******************************************************************************/
/******************************************************************************/
/**
 * @brief       テストタスクA
 * @details     カウントアップし続けながらカウンタを画面出力する。
 */
/******************************************************************************/
void TestTaskA( void )
{
    char     c;
    uint32_t num;
    uint32_t digit;
    
    while ( 1 ) {
        /* 16進数の1桁毎に繰り返し */
        for ( digit = 0; digit < 8; digit++ ) {
            /* 数取得 */
            num = ( gTestCounterA >> ( digit * 4 ) ) & 0xF;
            
            /* 数判定 */
            if ( ( 0 <= num ) && ( num <= 9 ) ) {
                /* 0～9 */
                
                /* 文字変換 */
                c = '0' + num;
                
            } else {
                /* A～F */
                
                /* 文字変換 */
                c = 'A' + num - 0xA;
            }
            
            /* 文字出力 */
            *( ( char * ) ( 0xB80A0 + 136 - digit * 2 ) ) = c;
        }
        
        /* カウンタインクリメント */
        gTestCounterA++;
    }
}


/******************************************************************************/
/**
 * @brief       テストタスクB
 * @details     カウントアップし続けながらカウンタを画面出力する。
 */
/******************************************************************************/
void TestTaskB( void )
{
    char     c;
    uint32_t num;
    uint32_t digit;
    
    while ( 1 ) {
        /* 16進数の1桁毎に繰り返し */
        for ( digit = 0; digit < 8; digit++ ) {
            /* 数取得 */
            num = ( gTestCounterB >> ( digit * 4 ) ) & 0xF;
            
            /* 数判定 */
            if ( ( 0 <= num ) && ( num <= 9 ) ) {
                /* 0～9 */
                
                /* 文字変換 */
                c = '0' + num;
                
            } else {
                /* A～F */
                
                /* 文字変換 */
                c = 'A' + num - 0xA;
            }
            
            /* 文字出力 */
            *( ( char * ) ( 0xB8140 + 136 - digit * 2 ) ) = c;
        }
        
        /* カウンタインクリメント */
        gTestCounterB++;
    }
}


/******************************************************************************/
