﻿/**
 * このプログラムは、任意のファイルをNyLPC_TRomFs形式のデータに変換します。
 *
 *
 */
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace File2FileStruct
{
    class Program
    {
        static void writeTitle()
        {
            System.Console.Out.WriteLine("File2FileStruct");
            System.Console.Out.WriteLine("This program converts binary file to .c format file.");
            System.Console.Out.WriteLine("File2FileStruct [filename]");
        }
        static void Main(string[] args)
        {
            writeTitle();
            if (args.Length == 0)
            {
                return;
            }
            String fname = args[0];
            byte[] data;
            //ファイルを開く
            using (System.IO.FileStream fs = new System.IO.FileStream(
                fname,
                System.IO.FileMode.Open,
                System.IO.FileAccess.Read))
            {
                data = new byte[fs.Length];
                fs.Read(data, 0, data.Length);
                fs.Close();
            }
            Encoding sjisEnc = Encoding.GetEncoding("Shift_JIS");
            using (StreamWriter writer =
                  new StreamWriter(fname+".c", false, sjisEnc))
            {
                writer.WriteLine("struct NyLPC_TRomFileData file={");
                writer.WriteLine("\"" + fname + "\",");
                writer.WriteLine(data.Length + ",");
                writer.WriteLine("\"FILL HERE\",");
                writer.Write("\"");
                writer.Write(String.Format("\\x{0:X2}", data[0]));
                for (int i = 1; i < data.Length; i++)
                {
                    writer.Write(String.Format("\\x{0:X2}",data[i]));
                }
                writer.WriteLine("\"\r\n};");
                writer.Close();
            }
        }
    }
}
