name 'pleiades-pxy'
description 'Pleiades proxy node'

run_list(
  'role[grid-realm]',
  'role[ganglia-gmond]'
)

mcast_addr = '239.2.11.7'
port = '8649'

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'Proxy',
      'owner' => 'grid.example.com'
    },
    'static' => {
      ## static multi-cast
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
=begin
      ## static uni-cast
      'udp_send_channels' => [
        {
          'mcast_join' => '',
          'host' => "pxy00.#{this.domain}",
          'port' => port,
          'ttl' => ''
        },
        {
          'mcast_join' => '',
          'host' => "pxy01.#{this.domain}",
          'port' => port,
          'ttl' => ''
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ]
=end
    }
  }
)
