require 'rubygems'
require 'bracecomp'

name 'pleiades-gm'
description 'Pleiades ganglia gmetad node'

run_list(
  'role[nameservice-client-grid]',
  'role[ganglia-gmond]',
  'role[ganglia-gmetad]',
  'role[ganglia-web]'
)

this_domain = 'grid.example.com'
mcast_addr = '239.2.11.3'
port = '8649'
polling_interval = '30'
# for DataNode
head_node_nums = 2
digit_nums = 5
padstr = '0'
dn_data_sources = []
(0...2).step(40) {|v|
#(0...80).step(40) {|v|
  first_head = v.to_s.rjust(digit_nums, padstr)
  last_head = (v + head_node_nums -1).to_s.rjust(digit_nums, padstr)
  dn_data_sources.push( 
    {
      :name => "DataNode#{first_head}",
      :polling_interval => polling_interval,
      :address_list => "dn{#{first_head}..#{last_head}}.#{this_domain}".expand
    }
  )
}

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

default_attributes(
  'ganglia' => {
    'web' => {
      'Allow' => [
        "from .#{this_domain}",
        'from 192.168.0.0/16'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => 'GRID.EXAMPLE.COM',
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    }
  },
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'Ganglia',
      'owner' => this_domain
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ],
=begin
      ## static uni-cast
      'udp_send_channels' => [
        {
          'mcast_join' => '',
          'host' => "gm00.#{this.domain}",
          'port' => port,
          'ttl' => ''
        },
        {
          'mcast_join' => '',
          'host' => "gm01.#{this.domain}",
          'port' => port,
          'ttl' => ''
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ],
=end
    },
    # gmetad
    'gridname' => 'Pleiades',
    'trusted_hosts' => ['127.0.0.1'] + "nm0{0..1}.#{this_domain}".expand,
    'data_sources' => [
      {
        :name => 'Nagios',
        :polling_interval => polling_interval,
        :address_list => "nm0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'Ganglia',
        :polling_interval => polling_interval,
        :address_list => "gm0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'Gateway',
        :polling_interval => polling_interval,
        :address_list => "gw0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'Workflow',
        :polling_interval => polling_interval,
        :address_list => "wf0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'Proxy',
        :polling_interval => polling_interval,
        :address_list => "pxy0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'NameNode',
        :polling_interval => polling_interval,
        :address_list => "nn0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'HBaseMaster',
        :polling_interval => polling_interval,
        :address_list => "hm0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'JobTracker',
        :polling_interval => polling_interval,
        :address_list => "jt0{0..1}.#{this_domain}".expand
      },
      {
        :name => 'ResourceManager',
        :polling_interval => polling_interval,
        :address_list => "rm0{0..1}.#{this_domain}".expand
      },
    ] + dn_data_sources
  }
)
