#
# Cookbook Name:: jenkins-grid
# Attributes:: default
#
# Copyright 2016, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

#default['jenkins-grid']['with_ssl_cert_cookbook'] = false
#default['jenkins-grid']['ssl_cert']['common_name'] = node['fqdn']
default['jenkins-grid']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/jenkins"
default['jenkins-grid']['docker-compose']['jenkins_home'] = {
  'path' => '/var/lib/jenkins_home',
  'owner' => 1000,
}
jenkins_home_path = node['jenkins-grid']['docker-compose']['jenkins_home']['path']
default['jenkins-grid']['docker-compose']['config'] = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'jenkins' => {
      'restart' => 'always',
      'image' => 'jenkins:2.19.4',
      #'ports' => [
      #  '8080:8080',
      #  '50000:50000',
      #],
      #'environment' => {
      #},
      'volumes' => [
        jenkins_home_path.nil? ? nil : "#{jenkins_home_path}:/var/jenkins_home",
      ],
    },
  },
}
