#
# Cookbook Name:: hbase
# Attributes:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# default: for pseudo-distributed
default['hbase']['install_flavor'] = 'apache'
# 0.94.2 <= version < 0.95
default['hbase']['version'] = '0.94.8'
default['hbase']['archive_url'] = 'http://archive.apache.org/dist/hbase'
default['hbase']['member_of_hadoop'] = false
default['hbase']['with_security'] = false
## hbase-env.sh
default['hbase']['HBASE_PID_DIR'] = "#{node['grid']['vol_root']}/0/var/run/${USER}"
default['hbase']['HBASE_LOG_DIR'] = "#{node['grid']['vol_root']}/0/var/log/${USER}"
default['hbase']['HBASE_PREFIX'] = "#{node['grid']['app_root']}/hbase"
default['hbase']['HBASE_CLASSPATH'] = "#{node['hadoop']['HADOOP_PREFIX']}/conf"
default['hbase']['HBASE_OPTS'] = '-XX:+UseConcMarkSweepGC'
default['hbase']['HBASE_MANAGES_ZK'] = 'false'
## hbase-site.xml
default['hbase']['this.cluster.name'] = 'localhost'
default['hbase']['this.domain'] = 'localhost'
default['hbase']['this.realm'] = 'LOCALDOMAIN'
default['hbase']['this.keytab.dir'] = "#{node['grid']['etc_root']}/keytabs/#{node['hbase']['this.cluster.name']}"
default['hbase']['this.namenode.fqdn'] = 'localhost'
default['hbase']['hbase.rootdir'] = 'hdfs://${this.namenode.fqdn}:9000/hbase'
default['hbase']['hbase.cluster.distributed'] = 'true'
default['hbase']['hbase.zookeeper.property.clientPort'] = '2181'
default['hbase']['hbase.zookeeper.quorum'] = 'localhost'
### if with_security
default['hbase']['hbase.security.authentication'] = 'kerberos'
default['hbase']['hbase.security.authorization'] = 'true'
default['hbase']['hbase.rpc.engine'] = 'org.apache.hadoop.hbase.ipc.SecureRpcEngine'
default['hbase']['hbase.superuser'] = 'hbase'
default['hbase']['hbase.data.umask.enable'] = 'true'
default['hbase']['hbase.data.umask'] = '077'
default['hbase']['hbase.coprocessor.master.classes'] = 'org.apache.hadoop.hbase.security.access.AccessController'
default['hbase']['hbase.coprocessor.region.classes'] = 'org.apache.hadoop.hbase.security.token.TokenProvider,org.apache.hadoop.hbase.security.access.AccessController'
default['hbase']['hbase.master.kerberos.principal'] = 'hbase/localhost@${this.realm}'
default['hbase']['hbase.master.keytab.file'] = "#{node['hbase']['this.keytab.dir']}/hm.keytab"
default['hbase']['hbase.regionserver.kerberos.principal'] = 'hbase/_HOST@${this.realm}'
default['hbase']['hbase.regionserver.keytab.file'] = "#{node['hbase']['this.keytab.dir']}/hr.keytab"
#### for secure zookeeper access
default['hbase']['jaas_master_kerberos_principal'] = "hbase/localhost@#{node['hbase']['this.realm']}"
default['hbase']['jaas_master_keytab_file'] = node['hbase']['hbase.master.keytab.file']
default['hbase']['jaas_regionserver_kerberos_principal'] = "hbase/localhost@#{node['hbase']['this.realm']}"
default['hbase']['jaas_regionserver_keytab_file'] = node['hbase']['hbase.regionserver.keytab.file']
## extra settings
default['hbase']['extra_configs'] = {
  # e.g. 'hbase-site.xml' => {'k1' => 'v1', 'k2' => 'v2'},
  'hbase-env.sh' => {},
  'hbase-site.xml' => {
    #'hbase.rpc.protection' => 'privacy',
  }
}
#default['hbase'][''] = 

=begin
# e.g. for full-distributed 
default['hbase']['this.cluster.name'] = 'pleiades'
default['hbase']['this.domain'] = 'grid.example.com'
default['hbase']['this.namenode.fqdn'] = '${this.cluster.name}-nn.${this.domain}'
default['hbase']['hbase.zookeeper.quorum'] = 'zk00.grid.example.com,zk01.grid.example.com,zk02.grid.example.com'
## if with_security
default['hbase']['this.realm'] = 'GRID.EXAMPLE.COM'
default['hbase']['hbase.master.kerberos.principal'] = 'hbase/_HOST@${this.realm}'
### for secure zookeeper access
default['hbase']['jaas_master_kerberos_principal'] = "hbase/${this.fqdn}@#{node['hbase']['this.realm']}"
default['hbase']['jaas_regionserver_kerberos_principal'] = "hbase/${this.fqdn}@#{node['hbase']['this.realm']}"
=end
