#
# Cookbook Name:: berkshelf-api-server-ya
# Recipe:: app
#
# Copyright 2015, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

include_recipe 'berkshelf-api-server::app'

begin
    r = resources(:runit_service => 'berks-api')
    r.cookbook 'berkshelf-api-server-ya'
end

endpoints = node[:berkshelf_api][:config][:endpoints]
# deploy client keys from Chef Vault
endpoints.each {|endpoint|
  options = endpoint[:options]

  if options.has_key?(:client_key_vault_item) then
    item_conf = options[:client_key_vault_item]

    pkg = 'chef-vault'
    resources(:chef_gem => pkg) rescue chef_gem pkg do
      compile_time true if respond_to?(:compile_time)
      action :install
    end

    require 'chef-vault'
    item = ChefVault::Item.load(item_conf[:vault], item_conf[:name])
    secret = item[item_conf[:key]]

    file options[:client_key] do
      content secret
      sensitive true
      owner node[:berkshelf_api][:owner]
      group node[:berkshelf_api][:group]
      mode 0400
    end
  end
}

